package com.yodo1.advert.banner;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

/**
 * @author zhuxiaochen
 */
public class Yodo1BannerAlign {
    public static final int BannerAlignLeft = 1;
    public static final int BannerAlignHorizontalCenter = 1 << 1;
    public static final int BannerAlignRight = 1 << 2;
    public static final int BannerAlignTop = 1 << 3;
    public static final int BannerAlignVerticalCenter = 1 << 4;
    public static final int BannerAlignBottom = 1 << 5;

    public static RelativeLayout getRel(Activity activity) {
        FrameLayout frameLayout = (FrameLayout) activity.findViewById(android.R.id.content);
        RelativeLayout relativeLayout = new RelativeLayout(activity);
        frameLayout.addView(relativeLayout);
        return relativeLayout;
    }

    /**
     * 设置banner展示
     *
     * @param activity Activity
     * @param view     View
     */
    public static void removeYodo1BannerLayout(Activity activity, View view) {
        if ((ViewGroup) view.getParent() != null && ((ViewGroup) view.getParent()).getChildCount() > 0) {
            ((ViewGroup) view.getParent()).removeAllViews();
        }
    }

    /**
     * 设置banner展示, WRAP_CONTENT
     *
     * @param activity Activity
     * @param view     View
     * @param align    Align
     */
    public static void setYodo1BannerLayout(Activity activity, View view, int align) {
        RelativeLayout relativeLayout = getRel(activity);
        view.setLayoutParams(getLayoutParams(align));
        relativeLayout.addView(view);
    }

    /**
     * 设置banner展示, 展示固定大小, 320x50
     *
     * @param activity Activity
     * @param view     ViewGroup
     * @param align    Align
     */
    public static void setYodo1BannerLayoutForSize(Activity activity, ViewGroup view, int align) {
        RelativeLayout relativeLayout = getRel(activity);
        view.setLayoutParams(getLayoutParamsForSize(activity, align));
        relativeLayout.addView(view);
    }

    /**
     * 获取Banner View布局参数, WRAP_CONTENT
     *
     * @param align Align
     * @return Layout params of banner view
     */
    public static RelativeLayout.LayoutParams getLayoutParams(int align) {
        return getLayoutParams(align, ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    /**
     * 获取Banner View布局参数, 320x50
     *
     * @param activity Activity
     * @param align    Align
     * @return Layout params of banner view
     */
    public static RelativeLayout.LayoutParams getLayoutParamsForSize(Activity activity, int align) {
        //获得当前屏幕密度
        float scale = 3.0f;
        try {
            scale = activity.getResources().getDisplayMetrics().density;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return getLayoutParams(align, (int) (320 * scale), (int) (50 * scale));
    }

    /**
     * 获取Banner View布局参数
     *
     * @param align  Align
     * @param width  Width
     * @param height Height
     * @return Layout params of banner view
     */
    private static RelativeLayout.LayoutParams getLayoutParams(int align, int width, int height) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(width, height);

        if ((align & Yodo1BannerAlign.BannerAlignLeft) == Yodo1BannerAlign.BannerAlignLeft) {
            params.addRule(RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.TRUE);
        } else if ((align & Yodo1BannerAlign.BannerAlignHorizontalCenter) == Yodo1BannerAlign.BannerAlignHorizontalCenter) {
            params.addRule(RelativeLayout.CENTER_HORIZONTAL, RelativeLayout.TRUE);
        } else if ((align & Yodo1BannerAlign.BannerAlignRight) == Yodo1BannerAlign.BannerAlignRight) {
            params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);
        }

        if ((align & Yodo1BannerAlign.BannerAlignTop) == Yodo1BannerAlign.BannerAlignTop) {
            params.addRule(RelativeLayout.ALIGN_PARENT_TOP, RelativeLayout.TRUE);
        } else if ((align & Yodo1BannerAlign.BannerAlignVerticalCenter) == Yodo1BannerAlign.BannerAlignVerticalCenter) {
            params.addRule(RelativeLayout.CENTER_VERTICAL, RelativeLayout.TRUE);
        } else if ((align & Yodo1BannerAlign.BannerAlignBottom) == Yodo1BannerAlign.BannerAlignBottom) {
            params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, RelativeLayout.TRUE);
        }
        return params;
    }
}
