package com.yodo1.advert;

import android.app.Activity;

import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * @author yodo1
 */
public abstract class AdapterAdvertBase implements AdLifecycle {

    private Yodo1AdCallback interstitialCallback, videoCallback, bannerCallback, nativeCallback;
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback, reloadBannerCallback, reloadNativeCallback;

    private Yodo1Privacy privacy;

    private boolean initialized, interInitialized, videoInitialized, bannerInitialized, nativeInitialized;
    private boolean interLoaded, videoLoaded, bannerLoaded, nativeLoaded;

    /**
     * 获取广告平台的AdvertCode，要与类名后缀一致
     *
     * @return String adChannelCode
     */
    public abstract String getAdvertCode();

    /**
     * 获取广告平台的Sdk版本号
     *
     * @return String SdkVersion
     * @deprecated The method getSDKVesion has been deprecated, please use the method {@link #getSdkVersion} instead
     */
    @Deprecated
    public String getSDKVesion() {
        return null;
    }

    /**
     * 获取广告平台的Sdk版本号
     *
     * @return 3rd network SDK version
     */
    public String getSdkVersion() {
        return "";
    }

    /**
     * 获取广告Adapter的版本号
     *
     * @return adapter's version
     */
    public String getAdapterVersion() {
        return "";
    }

    /**
     * 校验广告SDK manifest声明是否正确
     *
     * @param activity Activity
     */
    public void validateAdsAdapter(Activity activity) {
    }

    /**
     * EU consent and GDPR
     *
     * @param privacy Yodo1's privacy
     * @param context Activity
     */
    public void setPrivacy(final Yodo1Privacy privacy, final Activity context) {
        this.privacy = privacy;
    }

    public Yodo1Privacy getPrivacy() {
        return privacy;
    }

    /**
     * Initialize Sdk
     *
     * @param activity           Activity
     * @param initializeCallback Yodo1AdInitializeCallback
     */
    public void initSdk(Activity activity, Yodo1AdInitializeCallback initializeCallback) {

    }

    /**
     * Initialize rewarded video ad
     *
     * @param activity           Activity
     * @param initializeCallback Yodo1AdInitializeCallback
     */
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
    }

    /**
     * Show reward video Ad
     *
     * @param activity Activity
     * @param callback Yodo1AdCallback
     */
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
    }

    /**
     * Reload reward video Ad
     *
     * @param activity       Activity
     * @param reloadCallback Yodo1ReloadCallback
     */
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
    }

    /**
     * Whether reward video ads have been cached.
     *
     * @param activity Activity
     * @return true, if the reward video ads have been cached, false otherwise.
     */
    public boolean videoAdvertIsLoaded(Activity activity) {
        return false;
    }

    /**
     * Initialize interstitial ad
     *
     * @param activity           Activity
     * @param initializeCallback Yodo1AdInitializeCallback
     */
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
    }

    /**
     * Show interstitial Ad.
     *
     * @param activity Activity
     * @param callback Yodo1AdCallback
     */
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
    }

    /**
     * Reload interstitial Ad
     *
     * @param activity Activity
     * @param callback Yodo1ReloadCallback
     */
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
    }

    /**
     * Whether the interstitial ads have been cached
     *
     * @param activity Activity
     * @return true, if the interstitial ads have been cached, false otherwise.
     */
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return false;
    }

    /**
     * Initialize banner ad
     *
     * @param activity           Activity
     * @param initializeCallback Yodo1AdInitializeCallback
     */
    public void initBannerAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
    }

    /**
     * Show banner Ad
     *
     * @param activity Activity
     * @param callback Yodo1AdCallback
     */
    public void showBanner(Activity activity, Yodo1AdCallback callback) {
    }

    /**
     * Remove banner ad
     *
     * @param activity Activity
     */
    public void removeBanner(Activity activity) {
    }

    /**
     * Hide banner ad
     *
     * @param activity Activity
     */
    public void hideBanner(Activity activity) {
    }

    /**
     * 设置广告显示位置
     *
     * @param activity Activity
     * @param align    The alignment of banner ad, such as: Bottom center(BannerAlign.HorizontalCenter|BannerAlign.Bottom)
     */
    public void setBannerAlign(Activity activity, int align) {
    }

    /**
     * Whether the banner ads have been cached
     *
     * @return true, if the banner ads have been cached, false otherwise.
     */
    public boolean hasLoadBanner() {
        return false;
    }

    /**
     * Initialize native(原生) ad
     *
     * @param activity           Activivty
     * @param initializeCallback Yodo1AdInitializeCallback
     */
    public void initNativeAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
    }

    /**
     * Show native(原生) Ad.
     *
     * @param activity Activity
     * @param px       广告的x位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param py       广告的y位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param pw       广告的宽度width，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param ph       广告的高度height，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param callback Yodo1AdCallback
     */
    public void showNativeAdvert(Activity activity, float px, float py, float pw, float ph, Yodo1AdCallback callback) {
    }

    /**
     * Remove native(原生) ad
     *
     * @param activity Activity
     */
    public void removeNativeAdvert(Activity activity) {
    }

    /**
     * Reload native(原生) ad
     *
     * @param activity Activity
     * @param callback Yodo1ReloadCallback
     */
    public void reloadNativeAdvert(Activity activity, Yodo1ReloadCallback callback) {
    }

    /**
     * Whether the native ads have been cached
     *
     * @param activity Activity
     * @return true, if the native ads have been cached, false otherwise.
     */
    public boolean nativeAdvertIsLoaded(Activity activity) {
        return false;
    }

    /**
     * Show splash Ad.
     *
     * @param activity Activity
     * @param callback Yodo1AdCallback
     */
    public void showSplashAdvert(Activity activity, Yodo1AdCallback callback) {
    }

    /**
     * 获取Interstitial Callback
     *
     * @return Yodo1AdCallback
     * @deprecated The method getIntersititalCallback has been deprecated, please use the method {@link #getInterstitialCallback} instead
     */
    @Deprecated
    public Yodo1AdCallback getIntersititalCallback() {
        return getInterstitialCallback();
    }

    /**
     * 获取Interstitial Callback
     *
     * @return Yodo1AdCallback
     */
    public Yodo1AdCallback getInterstitialCallback() {
        return this.interstitialCallback;
    }

    /**
     * 设置Interstitial Callback
     *
     * @param interstitialCallback Yodo1AdCallback
     * @deprecated The method setIntersititalCallback has been deprecated, please use the method {@link #setInterstitialCallback} instead
     */
    @Deprecated
    public void setIntersititalCallback(Yodo1AdCallback interstitialCallback) {
        this.setInterstitialCallback(interstitialCallback);
    }

    /**
     * 设置Interstitial Callback
     *
     * @param interstitialCallback Yodo1AdCallback
     */
    public void setInterstitialCallback(Yodo1AdCallback interstitialCallback) {
        this.interstitialCallback = interstitialCallback;
    }

    public Yodo1AdCallback getVideoCallback() {
        return videoCallback;
    }

    public void setVideoCallback(Yodo1AdCallback videoCallback) {
        this.videoCallback = videoCallback;
    }

    public Yodo1AdCallback getBannerCallback() {
        return bannerCallback;
    }

    public void setBannerCallback(Yodo1AdCallback bannerCallback) {
        this.bannerCallback = bannerCallback;
    }

    public Yodo1ReloadCallback getReloadInterCallback() {
        return reloadInterCallback;
    }

    public void setReloadInterCallback(Yodo1ReloadCallback reloadInterCallback) {
        this.reloadInterCallback = reloadInterCallback;
    }

    public Yodo1ReloadCallback getReloadVideoCallback() {
        return reloadVideoCallback;
    }

    public void setReloadVideoCallback(Yodo1ReloadCallback reloadVideoCallback) {
        this.reloadVideoCallback = reloadVideoCallback;
    }

    public Yodo1ReloadCallback getReloadBannerCallback() {
        return reloadBannerCallback;
    }

    public void setReloadBannerCallback(Yodo1ReloadCallback reloadBannerCallback) {
        this.reloadBannerCallback = reloadBannerCallback;
    }

    public Yodo1AdCallback getNativeCallback() {
        return nativeCallback;
    }

    public void setNativeCallback(Yodo1AdCallback nativeCallback) {
        this.nativeCallback = nativeCallback;
    }

    public Yodo1ReloadCallback getReloadNativeCallback() {
        return reloadNativeCallback;
    }

    public void setReloadNativeCallback(Yodo1ReloadCallback reloadNativeCallback) {
        this.reloadNativeCallback = reloadNativeCallback;
    }

    public boolean isInitialized() {
        return initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isInterInitialized() {
        return interInitialized;
    }

    public void setInterInitialized(boolean interInitialized) {
        this.interInitialized = interInitialized;
    }

    public boolean isVideoInitialized() {
        return videoInitialized;
    }

    public void setVideoInitialized(boolean videoInitialized) {
        this.videoInitialized = videoInitialized;
    }

    public boolean isBannerInitialized() {
        return bannerInitialized;
    }

    public void setBannerInitialized(boolean bannerInitialized) {
        this.bannerInitialized = bannerInitialized;
    }

    public boolean isNativeInitialized() {
        return nativeInitialized;
    }

    public void setNativeInitialized(boolean nativeInitialized) {
        this.nativeInitialized = nativeInitialized;
    }

    public boolean isInterLoaded() {
        return interLoaded;
    }

    public void setInterLoaded(boolean interLoaded) {
        this.interLoaded = interLoaded;
    }

    public boolean isVideoLoaded() {
        return videoLoaded;
    }

    public void setVideoLoaded(boolean videoLoaded) {
        this.videoLoaded = videoLoaded;
    }

    public boolean isBannerLoaded() {
        return bannerLoaded;
    }

    public void setBannerLoaded(boolean bannerLoaded) {
        this.bannerLoaded = bannerLoaded;
    }

    public boolean isNativeLoaded() {
        return nativeLoaded;
    }

    public void setNativeLoaded(boolean nativeLoaded) {
        this.nativeLoaded = nativeLoaded;
    }
}
