package com.sensorsdata.analytics.android.minisdk;

import android.util.Log;

/**
 * @author :huangguofeng
 * date :2020-03-24
 * package :com.sensorsdata.analytics.android.minisdk.utils
 * desc    : Sensors 日志类
 */
public class SALog {
    private static Yodo1SensorsDataAPI mYodo1SensorsDataAPI;

    private SALog() {

    }

    public static void init(Yodo1SensorsDataAPI yodo1SensorsDataAPI) {
        mYodo1SensorsDataAPI = yodo1SensorsDataAPI;
    }

    public static void d(String tag, String msg) {
        try {
            if (mYodo1SensorsDataAPI.isDebugMode()) {
                Log.i(tag, msg);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void d(String tag, String msg, Throwable tr) {
        try {
            if (mYodo1SensorsDataAPI.isDebugMode()) {
                Log.i(tag, msg, tr);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void i(String tag, String msg) {
        try {
            if (Yodo1SensorsDataAPI.ENABLE_LOG) {
                Log.i(tag, msg);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void i(String tag, Throwable tr) {
        try {
            if (Yodo1SensorsDataAPI.ENABLE_LOG) {
                Log.i(tag, "", tr);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void i(String tag, String msg, Throwable tr) {
        try {
            if (Yodo1SensorsDataAPI.ENABLE_LOG) {
                Log.i(tag, msg, tr);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
