package com.yodo1.onlineconfig;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationManager;
import android.text.TextUtils;

import com.yodo1.android.ops.net.HttpListener;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.android.ops.net.Yodo1RequestListener;
import com.yodo1.android.ops.net.Yodo1SDKResponse;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.MD5EncodeUtil;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Cache;
import com.yodo1.sdk.kit.Yodo1PropertiesUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by yodo1 on 2017/8/7.
 */

public class Yodo1OnlineConfig {
    private static final String onlineConfigUrl = "https://olc.yodo1api.com/config/getData/";
    private static final String onlineConfigCDNUrl = "https://ocd.yodo1api.com/configfiles/";
    public static final String ONLINECONFIG_ACTION = "cn.yodo1.broadcastreceiverregister.OnlineConfig";
    private static final String DATAIDENTIFER = "data_identifer";
    private static final String LOCATION_IDENTIFER = "location_identifer";
    private static final String LOCATION_IDENTIFER_TTL = "location_identifer_ttl";
    private static final String GAME_APPK = "game_appkey";
    private static final String GAME_CHANNELCODE = "game_channelcode";
    private static final String GAME_VERSIONNAME = "game_version";
    private static final String TIMESTAMP_GETDATA = "timestamp_getdata";
    private static final String ONLINECONFIG = "OnlineConfigParams";
    public static String ChannelCode = "";
    private static Yodo1Cache yodo1Cache;
    private static Yodo1OnlineConfig instance;
    private static long time = 0;
    public JSONObject object = null;
    private String data = "";
    private String appKey = "";
    private boolean isTest = false;
    private Context context;
    private boolean hasInit = false;//广告在线参数是否已经获取
    //地理标识
    private String location_lng = "";//手机当前经度，保留小数点后两位
    private String location_lat = "";//手机当前纬度，保留小数点后两位
    private LocationManager locationManager;
    private Location location;

    private Yodo1OnlineConfig() {
    }

    public static Yodo1OnlineConfig getInstance() {
        if (instance == null) {
            instance = new Yodo1OnlineConfig();
        }
        return instance;
    }

    public JSONObject getJsonData() throws JSONException {

        if (object != null) {
            return object;//若JsaonArray数据不为空  直接返回
        }

        if (!TextUtils.isEmpty(data)) {
            object = new JSONObject(data);
        }
        return object;
    }

    /**
     * 判断本地是否有数据
     *
     * @return
     */
    public boolean hasData() {
        boolean bl = false;
        if (!TextUtils.isEmpty(data)) {
            bl = true;
        }
        return bl;
    }

    /**
     * 提供给外部调用
     */
    public void getOnlineConfig(final Context context) {
        //判断时间
        if (TextUtils.isEmpty(appKey)) {
            YLog.d("Yodo1GetOnlineConfig    appKey为空");
            return;
        }
        //后台进入前台二十分钟后重新请求数据
        if (System.currentTimeMillis() - time < 60000 * 20) {
            return;
        }
        time = System.currentTimeMillis();

        getOnlineConfig(context, appKey, new Yodo1RequestListener() {
            @Override
            public void onYodo1RequestComplete(Yodo1SDKResponse responseObject) {
                String resMsg = responseObject.getResponseString();
                int errorCode = -1;
                try {
                    if (resMsg != null) {
                        JSONObject jsonObj = new JSONObject(resMsg.replace(" ", ""));
                        errorCode = jsonObj.optInt("error_code");

                        if (errorCode == 0) {
                            String data_identifer = jsonObj.optString("data_identifer");
                            data = jsonObj.optString("data");
                            String location_identifer = jsonObj.optString("location_identifer");//地理标识  客户端本地存
                            String location_identifer_ttl = jsonObj.optString("location_identifer_ttl");//地理标识有效时长   小时，客户端本地存

                            yodo1Cache.putAESData(DATAIDENTIFER, data_identifer);
                            yodo1Cache.putAESData(ONLINECONFIG, data);

                            //当本地地理标识为空的时候再保存获取到的地理标识
                            if (TextUtils.isEmpty(yodo1Cache.getAESData(LOCATION_IDENTIFER))) {
                                yodo1Cache.putAESData(LOCATION_IDENTIFER, location_identifer);
                            }
                            yodo1Cache.putAESData(LOCATION_IDENTIFER_TTL, location_identifer_ttl);
                            yodo1Cache.putAESData(TIMESTAMP_GETDATA, System.currentTimeMillis() + "");//成功获取在线参数之后的时间戳

                            yodo1Cache.putAESData(GAME_APPK, appKey);
                            yodo1Cache.putAESData(GAME_CHANNELCODE, ChannelCode);
                            yodo1Cache.putAESData(GAME_VERSIONNAME, SysUtils.getVersionName(context) + "");
                            YLog.d("Yodo1GetOnlineConfig   获取在线参数 " + resMsg);
                            sendMsg();
                        } else if (errorCode == 10) {
                            YLog.d("Yodo1GetOnlineConfig   本地参数已是最新，无需更新");
                            sendMsg();
                        } else {
                            String error = jsonObj.optString("error");
                            YLog.d("Yodo1GetOnlineConfig   获取在线参数异常,需获取静态参数  ErrorCode： " + errorCode + "    Error : " + error);
                            //需拼接静态参数，获取在线参数静态数据

                            getCDNOnlineConfig();
                        }

                    } else {
                        time = 0;
                        getCDNOnlineConfig();
                    }
                } catch (JSONException e) {
                    YLog.d("Yodo1GetOnlineConfig   json解析异常 " + e.getMessage() + "   " + e.getCause());
                    time = 0;
                    getCDNOnlineConfig();
                }

            }
        });
    }

    /**
     * 获取在线参数
     *
     * @param key
     * @return
     */
    public String getConfigParam(String key, String defaultValue) {
        String result = defaultValue;
        try {
            JSONObject obj = getJsonData();
            if (obj != null && !TextUtils.isEmpty(obj.optString(key))) {
                result = obj.optString(key);
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d("Yodo1GetOnlineConfig    key = " + key);
        YLog.d("Yodo1GetOnlineConfig    result = " + result);
        return result;

    }

    /**
     * 在线参数初始化
     *
     * @param context
     */
    public void init(final Context context, final String appKey) {
        this.appKey = appKey;
        this.context = context;
        if (TextUtils.isEmpty(ChannelCode)) {
            getYodo1ChannelCode();
        }

        if (yodo1Cache == null) {
            yodo1Cache = Yodo1Cache.get(context);
        }

        if (TextUtils.isEmpty(data)) {
            data = yodo1Cache.getAESData(ONLINECONFIG);
        }

        if (!TextUtils.isEmpty(appKey) && !hasInit) {
            hasInit = true;
            getLocation(context);//读取当前位置
            getOnlineConfig(context);
        }

    }

    private String getYodo1ChannelCode() {
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager()
                    .getApplicationInfo(context.getPackageName(),
                            PackageManager.GET_META_DATA);
            ChannelCode = appInfo.metaData.getString("Yodo1ChannelCode");

        } catch (Exception e) {
            YLog.d("Yodo1GetOnlineConfig    ChannelCode未获取到，采用默认值");
        }

        if (TextUtils.isEmpty(ChannelCode)) {
            ChannelCode = Yodo1PropertiesUtils.getInstance().getBasicConfigValue("CHANNEL_CODE_PUBLISH"); //加载发布渠道代码
        }

        if (TextUtils.isEmpty(ChannelCode)) {
            ChannelCode = "Default";
        }
        YLog.d("Yodo1Advert 当前渠道为：  " + ChannelCode);
        return ChannelCode;
    }

    /**
     * 根据接口获取在线参数
     *
     * @param listener 回调
     * @param context
     */
    private void getOnlineConfig(Context context, String appKey, final Yodo1RequestListener listener) {
        if (yodo1Cache == null) {
            yodo1Cache = Yodo1Cache.get(context);
        }

        String version = Yodo1SharedPreferences.getString(context, "appVersion");
        if (TextUtils.isEmpty(version)) {
            version = SysUtils.getVersionName(context) + "";
        }

        if (TextUtils.isEmpty(version)) {
            YLog.i("Yodo1GetOnlineConfig   VersionName未获取到，采用默认值");
            version = "Default";//若获取的VersionName为空，传值为通用版本号
        }

        String data = yodo1Cache.getAESData(DATAIDENTIFER);
        String data_identifer = "0";
        if (!TextUtils.isEmpty(data)) {
            data_identifer = String.valueOf(yodo1Cache.getAESData(DATAIDENTIFER));
        }
        String time = System.currentTimeMillis() + "";
        String sign = MD5EncodeUtil.MD5Encode(appKey + version + ChannelCode + time + "yodo1");

        if (TextUtils.isEmpty(data_identifer)) {
            data_identifer = "0";
        }
        if (!TextUtils.isEmpty(data_identifer) && data_identifer.equals("null")) {
            data_identifer = "0";
        }

        String local_appkey = yodo1Cache.getAESData(GAME_APPK);
        String local_channel = yodo1Cache.getAESData(GAME_CHANNELCODE);
        String local_version = yodo1Cache.getAESData(GAME_VERSIONNAME);
        if ((!TextUtils.isEmpty(local_appkey) && !local_appkey.equals(appKey)) || (!TextUtils.isEmpty(local_channel) && !local_channel.equals(ChannelCode)) ||
                (!TextUtils.isEmpty(local_version) && !local_version.equals(version))) {
            data_identifer = "0";
        }
        String location_identifer = yodo1Cache.getAESData(LOCATION_IDENTIFER);
        String location_identifer_ttl = yodo1Cache.getAESData(LOCATION_IDENTIFER_TTL);
        String timestamp_getdata = yodo1Cache.getAESData(TIMESTAMP_GETDATA);

        if (!TextUtils.isEmpty(location_identifer)) {
            try {
                long time_ttl = Long.valueOf(location_identifer_ttl);
                long time_getdata = Long.valueOf(timestamp_getdata);

                //在线参数本次请求的时间戳和上次请求返回的时间戳比较   大于上次请求返回的有效时长  清空location_identifer和data_identifer
                if ((time_getdata - System.currentTimeMillis()) > (time_ttl * 60 * 60 * 1000)) {
                    location_identifer = "";
                    data_identifer = "0";
                    yodo1Cache.putAESData(LOCATION_IDENTIFER, "");//删除本地已经缓存的地理标识
                }
            } catch (NumberFormatException e) {
                location_identifer = "";
            }

        } else {
            location_identifer = "";
        }


        JSONObject dataJson = new JSONObject();
        try {
            dataJson.put("game_appkey", appKey);
            dataJson.put("version", version);
            dataJson.put("channel", ChannelCode);
            dataJson.put("data_identifer", data_identifer);
            dataJson.put("location_identifer", location_identifer);
            dataJson.put("location_lng", location_lng);
            dataJson.put("location_lat", location_lat);
            dataJson.put("timestamp", time);
            dataJson.put("sign", sign);

        } catch (JSONException e) {
            e.printStackTrace();
        }

        String submitStr = dataJson.toString();
        YLog.d("Yodo1GetOnlineConfig   请求在线参数 : " + submitStr);
        Request<String> request = NoHttp.createStringRequest(onlineConfigUrl, RequestMethod.POST);
        request.setDefineRequestBody(submitStr, "text/plain;charset=UTF-8");
        Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>() {
            @Override
            public void onSucceed(int what, Response<String> response) {
                YLog.d("Yodo1GetOnlineConfig  获取到在线参数===" + response.get());
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                listener.onYodo1RequestComplete(resp);
            }

            @Override
            public void onFailed(int what, Response<String> response) {
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                listener.onYodo1RequestComplete(resp);
            }
        }, false);

    }

    /**
     * 根据接口获取在线参数静态数据
     */
    private void getCDNOnlineConfig() {
        getCDNOnlineConfig(new Yodo1RequestListener() {
            @Override
            public void onYodo1RequestComplete(Yodo1SDKResponse responseObject) {
                String resMsg = responseObject.getResponseString();
                YLog.d("Yodo1GetOnlineConfig   获取CDN在线参数 " + resMsg);
                try {
                    if (resMsg != null) {
                        JSONObject jsonObj = new JSONObject(resMsg.replace(" ", ""));
                        String data_identifer = jsonObj.optString("data_identifer");

                        String local_data = yodo1Cache.getAESData(DATAIDENTIFER);

                        if (TextUtils.isEmpty(local_data)) {
                            local_data = "0";
                        }

                        if (Long.valueOf(data_identifer) > Long.valueOf(local_data)) {
                            data = jsonObj.optString("data");
                            yodo1Cache.putAESData(DATAIDENTIFER, data_identifer);
                            yodo1Cache.putAESData(ONLINECONFIG, data);
                        } else {
                            data = yodo1Cache.getAESData(ONLINECONFIG);
                        }

                        sendMsg();
                    } else {
                        time = 0;
                    }

                } catch (JSONException e) {
                    YLog.d("Yodo1GetOnlineConfig   json解析异常 " + e.getMessage() + "   " + e.getCause());
                    time = 0;
                }

            }
        });
    }

    /**
     * 根据接口获取在线参数
     *
     * @param listener 回调
     */
    private void getCDNOnlineConfig(final Yodo1RequestListener listener) {
        String domain = "";
        String url = "";
        if (isTest) {
            domain = "http://192.168.1.132:8000/";
            url = domain + appKey + ".json";
        } else {
            domain = onlineConfigCDNUrl;
            url = domain + MD5EncodeUtil.MD5Encode(appKey) + ".json";
        }

        Request<String> request = NoHttp.createStringRequest(url);
        Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>() {
            @Override
            public void onSucceed(int what, Response<String> response) {
                YLog.d("Yodo1GetOnlineConfig   CDN ===" + response.get());
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(0, response);
                listener.onYodo1RequestComplete(resp);
            }

            @Override
            public void onFailed(int what, Response<String> response) {
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(0, response);
                listener.onYodo1RequestComplete(resp);
            }
        }, false);
    }

    /**
     * 拉取到在线参数之后发送广播初始化
     */
    private void sendMsg() {
        YLog.d("Yodo1GetOnlineConfig     拿到在线参数，发送广播");
        context.sendBroadcast(new Intent(ONLINECONFIG_ACTION));
    }

    private void getLocation(Context context) {
        locationManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);
        try {
            location = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
            if (location != null) {
                YLog.d("Yodo1GetOnlineConfig   当前GPS定位经纬度为 ： getLatitude ： " + location.getLatitude() + "  getLongitude："
                        + location.getLongitude());
                location_lng = String.format("%.2f", location.getLongitude());
                location_lat = String.format("%.2f", location.getLatitude());
            } else {
                location = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);

                if (location != null) {
                    YLog.d("Yodo1GetOnlineConfig   当前网络定位经纬度为 ： getLatitude ： " + location.getLatitude() + "  getLongitude："
                            + location.getLongitude());

                    location_lng = String.format("%.2f", location.getLongitude());
                    location_lat = String.format("%.2f", location.getLatitude());
                }
            }
        } catch (SecurityException e) {
            YLog.d("Yodo1GetOnlineConfig   当前定位异常");
        }
    }
}
