package com.yodo1.advert.video.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.yodo1.advert.plugin.oneway.AdConfigOneway;
import com.yodo1.advert.plugin.oneway.AdvertCoreOneway;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;

import mobi.oneway.sdk.OWRewardedAd;
import mobi.oneway.sdk.OWRewardedAdListener;
import mobi.oneway.sdk.OnewayAdCloseType;
import mobi.oneway.sdk.OnewaySdkError;

/**
 * Created by yodo1 on 17/9/14.
 */
public class AdvertAdapteroneway extends AdVideoAdapterBase {

    private boolean isLoaded;
    private Yodo1VideoCallback adCallback;
    private Yodo1VideoReloadCallback reloadCallback;

    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        adCallback = callback;

        if(TextUtils.isEmpty(AdConfigOneway.PUBLISH_ID)) {
            YLog.e("AdvertAdapterOneway, video PUBLISH_ID is null");
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未获取到PUBLISH_ID", getAdvertCode());
            return;
        }


        if(isLoaded &&  OWRewardedAd.isReady() ) {
            OWRewardedAd.show( activity);
        } else {
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
        isLoaded = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback=reloadCallback;
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return isLoaded;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigOneway.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreOneway.getInstance().validateAdsAdapter(activity);

    }


    private OWRewardedAdListener rewardedAdListener = new OWRewardedAdListener() {
        @Override
        public void onAdReady() {
            isLoaded = true;
            YLog.d("AdvertAdapterOnyway.onAdReady");
            if (reloadCallback != null){
                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH, getAdvertCode());
            }

        }

        @Override
        public void onAdShow(String s) {
            YLog.d("AdvertAdapterOnyway.onAdShow");
            if (adCallback != null){
                adCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdClick(String s) {
            if (adCallback != null){
                adCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdClose(String s, OnewayAdCloseType onewayAdCloseType) {
            YLog.d("AdvertAdapterOnyway.onAdClose : " + s);
            if (adCallback != null){
                adCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

        }

        @Override
        public void onAdFinish(String s, OnewayAdCloseType onewayAdCloseType) {
            YLog.d("AdvertAdapterOnyway.onAdFinish : " + s);
            if (adCallback != null){
                adCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onSdkError(OnewaySdkError onewaySdkError, String s) {
            YLog.i("AdvertAdapterOnyway.onSdkError : " + s);

        }
    };

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AdvertCoreOneway.getInstance().init(activity);

        OWRewardedAd.init(rewardedAdListener);

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
