package com.yodo1.advert.unity;

import android.app.Activity;

import com.unity3d.player.UnityPlayer;
import com.yodo1.advert.open.Yodo1Advert;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONArray;

import java.util.ArrayList;


public class UnityYodo1SDK {

    private static Activity activity = null;
    private static UnityYodo1MessageListener listener = null;

    /**
     * 初始化
     * @param gameAppKey
     * @param activity
     */
    public static void initSDK(final Activity activity ,String gameAppKey) {
        UnityYodo1SDK.activity = activity;
        UnityYodo1SDK.onCreate(activity, new UnityYodo1MessageListener() {
            @Override
            public void unitySendMessage(String go, String m, String p) {
                UnityPlayer.UnitySendMessage(go, m, p);
            }
        });
        Yodo1Advert.initSDK(activity, gameAppKey);
    }

    public static ArrayList<String> getList(JSONArray jsonArray) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            for (int i = 0; i < jsonArray.length(); i++) {
                String msg = jsonArray.getString(i);
                list.add(msg);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    /**
     * 设置测试模式
     *
     */
    public static void setLogEnable(boolean enable) {
        Yodo1Advert.setOnLog(enable);
    }



    /**
     * 生命周期onCreate调用
     *
     * @param activity
     */
    public static void onCreate(final Activity activity, UnityYodo1MessageListener listener) {
        UnityYodo1SDK.activity = activity;
        UnityYodo1SDK.listener = listener;


    }


    /**
     * 生命周期onDestroy调用
     *
     */
    public static void onDestroy() {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.onDestroy(activity);
            }
        });

    }

    /**
     * 生命周期onResume调用
     *
     */
    public static  void onResume() {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.onResume(activity);
            }
        });

    }

    public static  void onRestart(){
    }

    /**
     * 生命周期onPause调用
     *
     */
    public static  void onPause() {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.onPause(activity);
            }
        });

    }

    /**
     * 生命周期onStart调用
     *
     */
    public static void onStart() {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.onStart(activity);
            }
        });

    }

    /**
     * 生命周期onStop调用
     *
     */
    public static void onStop() {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.onStop(activity);
            }
        });

    }

    /**
     * 生命周期onBackPressed调用
     *
     * @return
     */
//    public static boolean onBackPressed() {
//        return Yodo1GlobalSDK.onBackPressed();
//    }

    public static Activity getActivity() {
        return activity;
    }

    public static void unitySendMessage(String go, String m, String p) {
        YLog.i("Yodo1SDK, Android call Unity --- callname ：  " + m + "   sendMsg:  " + p);
        if (listener != null) {
            listener.unitySendMessage(go, m, p);
        }
    }


}
