package com.yodo1.advert.splash.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.uniplay.adsdk.SplashAdListener;
import com.uniplay.adsdk.SplashAdView;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.uniplay.AdConfigUniplay;
import com.yodo1.advert.splash.AdSplashAdapterBase;
import com.yodo1.advert.splash.Yodo1SplashCallback;
import com.yodo1.sdk.kit.RR;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdapteruniplay extends AdSplashAdapterBase{

    @Override
    public void showSplashAdvert(Activity activity,final Yodo1SplashCallback callback) {
        String splashId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd,
                AdConfigUniplay.CHANNEL_CODE, AdConfigUniplay.KEY_Uniplay_SPLASH_ID);

        if (TextUtils.isEmpty(splashId)){
            YLog.e("Uniplay SPLASH_ID  NULL");
            callback.onAdError(Yodo1SplashCallback.ADVERT_ERROR_COMMON,"Uniplay   splashId  null",getAdvertCode());

            return;
        }

//        String splashId = "1706150004";
        FrameLayout frameLayout = (FrameLayout)activity.findViewById(android.R.id.content);

        try{ SplashAdView splshAd = new SplashAdView(activity, frameLayout, splashId, new SplashAdListener() {
            @Override
            public void onSplashAdShow() {
                callback.onEvent(Yodo1SplashCallback.ADVERT_EVENT_DISPLAY,getAdvertCode());
            }

            @Override
            public void onSplashAdClick() {
                callback.onEvent(Yodo1SplashCallback.ADVERT_EVENT_CLICK,getAdvertCode());

            }

            @Override
            public void onSplashAdFailed(String result) {
                YLog.i("Uniplay onLoadFailed : " + result);
                callback.onAdError(Yodo1SplashCallback.ADVERT_ERROR_COMMON,"Uniplay   onLoadFailed",getAdvertCode());
            }

            @Override
            public void onSplashAdDismiss() {
                callback.onEvent(Yodo1SplashCallback.ADVERT_EVENT_CLOSE,getAdvertCode());

            }
        });

        } catch (Exception e) {
            YLog.i("Uniplay  onError  "  +  e.getMessage());
            callback.onAdError(Yodo1SplashCallback.ADVERT_ERROR_NO_AD,"Uniplay onError : " + e.getMessage(),getAdvertCode());
        }



    }

    @Override
    public String getAdvertCode() {
        return AdConfigUniplay.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
