package com.yodo1.advert.splash.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTSplashAd;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.toutiao.AdConfigToutiao;
import com.yodo1.advert.plugin.toutiao.AdvertCoreToutiao;
import com.yodo1.advert.splash.AdSplashAdapterBase;
import com.yodo1.advert.splash.Yodo1SplashCallback;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdaptertoutiao extends AdSplashAdapterBase{
    private int fetchDelay = 1000;
    private TTAdNative mTTAdNative;
    private FrameLayout mSplashContainer;
    @Override
    public void showSplashAdvert(Activity activity,final Yodo1SplashCallback callback) {
        String splash_id = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd, AdConfigToutiao.CHANNEL_CODE
                , AdConfigToutiao.KEY_SPLASH_ID);
        if(TextUtils.isEmpty(splash_id)){
            YLog.e("toutiao  splash is null");
            callback.onAdError(Yodo1SplashCallback.ADVERT_ERROR_COMMON,"toutiao  appid is null",getAdvertCode());
            return;
        }
//        AdConfigToutiao.splash_id = "801121648";
        //创建TTAdNative对象,用于调用广告请求接口

        try {
//            YLog.i("tt  开始初始化开屏广告");
            mTTAdNative = AdvertCoreToutiao.getAdManager(activity).createAdNative(activity);
            mSplashContainer = (FrameLayout)activity.getWindow().getDecorView();
//            YLog.i("tt  初始化开屏广告成功");

            AdSlot adSlot = new AdSlot.Builder()
                    .setCodeId(splash_id)
                    .setSupportDeepLink(true)
                    .setImageAcceptedSize(1080, 1920)
                    .build();

//            YLog.i("tt  初始化开屏广告设置");
            mTTAdNative.loadSplashAd(adSlot, new TTAdNative.SplashAdListener() {
                @Override
                public void onError(int i, String s) {
                    callback.onAdError(Yodo1SplashCallback.ADVERT_ERROR_NO_AD,"tt onError : " + s,getAdvertCode());
                }

                @Override
                public void onTimeout() {
                    callback.onAdError(Yodo1SplashCallback.ADVERT_ERROR_NO_AD,"tt onTimeout " ,getAdvertCode());
                }

                @Override
                public void onSplashAdLoad(TTSplashAd ad) {
                    YLog.d("tt  初始化开屏广告设置  onSplashAdLoad");
                    //获取SplashView
                    View view = ad.getSplashView();

                    mSplashContainer.removeAllViews();
                    //把SplashView 添加到ViewGroup中
                    mSplashContainer.addView(view);
                    //设置SplashView的交互监听器
                    ad.setSplashInteractionListener(new TTSplashAd.AdInteractionListener() {
                        @Override
                        public void onAdClicked(View view, int type) {
                            callback.onEvent(Yodo1SplashCallback.ADVERT_EVENT_CLICK,getAdvertCode());
                        }

                        @Override
                        public void onAdShow(View view, int type) {
                            callback.onEvent(Yodo1SplashCallback.ADVERT_EVENT_DISPLAY,getAdvertCode());
                        }

                        @Override
                        public void onAdSkip() {
                            callback.onEvent(Yodo1SplashCallback.ADVERT_EVENT_CLOSE,getAdvertCode());
                        }

                        @Override
                        public void onAdTimeOver() {
                            callback.onEvent(Yodo1SplashCallback.ADVERT_EVENT_CLOSE,getAdvertCode());
                        }
                    });
                }
            });

        } catch (Exception e) {
            YLog.i("TT  onError  "  +  e.getMessage());
            callback.onAdError(Yodo1SplashCallback.ADVERT_ERROR_NO_AD,"tt onError : " + e.getMessage(),getAdvertCode());
        }
    }

    @Override
    public String getAdvertCode() {
        return AdConfigToutiao.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
