package com.yodo1.advert.splash.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.qq.e.ads.splash.SplashAD;
import com.qq.e.ads.splash.SplashADListener;
import com.qq.e.comm.util.AdError;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.gdt.AdConfigGdt;
import com.yodo1.advert.splash.AdSplashAdapterBase;
import com.yodo1.advert.splash.Yodo1SplashCallback;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdaptergdt extends AdSplashAdapterBase{
    private int fetchDelay = 3000;

    @Override
    public void showSplashAdvert(Activity activity,final Yodo1SplashCallback callback) {

        AdConfigGdt.SPLASH_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd, AdConfigGdt.CHANNEL_CODE
                , AdConfigGdt.KEY_Gdt_SPLASH_ID);
        AdConfigGdt.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd, AdConfigGdt.CHANNEL_CODE
                , AdConfigGdt.KEY_Gdt_APP_ID);
        String  delay = Yodo1OnlineConfig.getInstance().getConfigParam("Platform_SplashAdShowTime","3");

        try {
            fetchDelay = Integer.valueOf(delay) * 1000;
        } catch (NumberFormatException e) {
            fetchDelay = 3000;
            YLog.e("fetchDelay 数据异常");

        }

        if (TextUtils.isEmpty(AdConfigGdt.APP_ID) && TextUtils.isEmpty(AdConfigGdt.SPLASH_ID)){
            YLog.i("GDT appid为空  不展示开屏广告");
            callback.onAdError(Yodo1SplashCallback.ADVERT_ERROR_COMMON,"gdt  appid is null",getAdvertCode());
            return;
        }
        YLog.i("gdt  splash  show");
//        AdConfigGdt.SPLASH_ID = "8863364436303842593";
//        AdConfigGdt.APP_ID = "1101152570";
        final ViewGroup adContainer = ((ViewGroup)activity.findViewById(android.R.id.content));
        SplashAD splashAD = new SplashAD(activity, adContainer, AdConfigGdt.APP_ID, AdConfigGdt.SPLASH_ID, new SplashADListener() {
            @Override
            public void onADDismissed() {
                callback.onEvent(Yodo1SplashCallback.ADVERT_EVENT_CLOSE,getAdvertCode());
            }

            @Override
            public void onNoAD(AdError adError) {
                YLog.i("gdt  splash  onNoAD : " + adError.getErrorCode());
                callback.onAdError(Yodo1SplashCallback.ADVERT_ERROR_NO_AD,adError.getErrorMsg(),getAdvertCode());
            }

            @Override
            public void onADPresent() {
                callback.onEvent(Yodo1SplashCallback.ADVERT_EVENT_DISPLAY,getAdvertCode());
            }

            @Override
            public void onADClicked() {
                callback.onEvent(Yodo1SplashCallback.ADVERT_EVENT_CLICK,getAdvertCode());
            }

            @Override
            public void onADTick(long l) {

            }

            @Override
            public void onADExposure() {

            }
        }, fetchDelay);
    }

    @Override
    public String getAdvertCode() {
        return AdConfigGdt.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
