package com.yodo1.advert.plugin.toutiao;

import android.content.Context;
import android.text.TextUtils;

import com.bytedance.sdk.openadsdk.TTAdConstant;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdManagerFactory;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 18/3/5.
 */

public class AdvertCoreToutiao {

    private static TTAdManager ttAdManager;
    private static boolean sInit;

    public static TTAdManager getAdManager(Context context){
        if(ttAdManager == null) {
            ttAdManager = TTAdManagerFactory.getInstance(context);
        }
        if (!sInit) {
            synchronized (AdvertCoreToutiao.class) {
                if (!sInit) {
                    init(ttAdManager,context);
                    sInit = true;
                }
            }
        }
        return ttAdManager;
    }

    private static void init(TTAdManager AdManager, Context context) {
        String appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigToutiao.CHANNEL_CODE
                , AdConfigToutiao.KEY_APPID);
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigToutiao.CHANNEL_CODE
                    , AdConfigToutiao.KEY_APPID);
        }
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd, AdConfigToutiao.CHANNEL_CODE
                    , AdConfigToutiao.KEY_APPID);
        }
        if (TextUtils.isEmpty(appId)) {
            YLog.e("今日头条 appid 未设置");
            return;
        }
//        appId = "5001121";
        AdManager.setAppId(appId)
                .setName(SysUtils.getAppName(context))
                .openDebugMode()
                .setDirectDownloadNetworkType(TTAdConstant.NETWORK_STATE_WIFI, TTAdConstant.NETWORK_STATE_3G);
    }


}

