package com.yodo1.advert.plugin.mintegral;

import android.app.Activity;
import android.os.Looper;
import android.text.TextUtils;

import com.mintegral.msdk.MIntegralConstans;
import com.mintegral.msdk.MIntegralSDK;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Created by yodo1 on 2016/4/21.
 */
public class AdvertCoreMobVista {
    private static AdvertCoreMobVista instance;
    private AdvertCoreMobVista(){}
    public static AdvertCoreMobVista getInstance(){
        if(instance == null){
            instance = new AdvertCoreMobVista();
        }
        return instance;
    }



    private boolean validate = false;
    public  void validateAdsAdapter(Activity activity){
        if(!validate) {
            List<String> mobActivities = Arrays.asList(new String[] { "com.mintegral.msdk.activity.MTGCommonActivity"
                    , "com.mintegral.msdk.reward.player.MTGRewardVideoActivity"
                    , "com.mintegral.msdk.mtgjscommon.authority.activity.MTGAuthorityActivity" });
            ValidateUtils.validateActivities(activity,mobActivities);


            List<String> mobService = Arrays.asList(new String[] { "com.mintegral.msdk.shell.MTGService" });
            ValidateUtils.validateServices(activity,mobService);


            List<String> mobReceiver = Arrays.asList(new String[] { "com.alphab.receiver.AlphabReceiver"
                    ,"com.mintegral.msdk.click.AppReceiver"});
            ValidateUtils.validateBroadcastReceivers(activity,mobReceiver);
            validate = true;
        }

    }

    private boolean isInit = false;
    private static String AppID;
    private static String AppKey;
    public  void init(final Activity activity){
        if(!isInit) {

            String AppID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                    AdConfigMobvista.CHANNEL_CODE,AdConfigMobvista.KEY_MOBVISTA_APP_ID);
            String AppKey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                    AdConfigMobvista.CHANNEL_CODE,AdConfigMobvista.KEY_MOBVISTA_APP_KEY);

            if (TextUtils.isEmpty( AppID) && TextUtils.isEmpty( AppKey)){
                 AppID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                        AdConfigMobvista.CHANNEL_CODE,AdConfigMobvista.KEY_MOBVISTA_APP_ID);
                 AppKey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                        AdConfigMobvista.CHANNEL_CODE,AdConfigMobvista.KEY_MOBVISTA_APP_KEY);
            }

//            MIntegralConstans.DEBUG = true;
//            AppID = "106628";
//            AppKey = "df5e047efe691d8596e6e732187f57eb";
            if (TextUtils.isEmpty( AppID) && TextUtils.isEmpty( AppKey)){
                YLog.e("Mobvista  key未获取到");
                return;
            }
            YLog.d("Mintegral  AppID:  " +  AppID);
            YLog.d("Mintegral  AppKey:  " +  AppKey);


            MIntegralSDK sdk = MIntegralSDKFactory.getMIntegralSDK();
            // test appId and appKey

            Map<String, String> map = sdk.getMTGConfigurationMap( AppID,  AppKey );

            // if you modify applicationId, please add the following attributes,
            // otherwise it will crash
            // map.put(MobVistaConstans.PACKAGE_NAME_MANIFEST, "your AndroidManifest
            // package value");
            sdk.init(map, activity.getApplication());
            isInit = true;
        }

    }

}
