package com.yodo1.advert.interstitial.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.mintegral.msdk.interstitialvideo.out.InterstitialVideoListener;
import com.mintegral.msdk.interstitialvideo.out.MTGInterstitialVideoHandler;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.mintegral.AdConfigMobvista;
import com.yodo1.advert.plugin.mintegral.AdvertCoreMobVista;
import com.yodo1.sdk.kit.YLog;


/**
 * Created by yodo1 on 2017/9/27.
 */
public class AdvertAdaptermintegral extends AdInterstitialAdapterBase {
    private boolean isLoded = false;
    private Yodo1InterstitialCallback intersititalCallback; //插屏回调
    private Yodo1InterstitialReloadCallback callback;
    private MTGInterstitialVideoHandler mMtgInterstitalVideoHandler;

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1InterstitialCallback callback) {
        this.intersititalCallback = callback;
        YLog.i("Mintegral showIntersititalAdvert");
        if (mMtgInterstitalVideoHandler !=null && isLoded) {
            mMtgInterstitalVideoHandler.show();
        } else {
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
        isLoded = false;
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        YLog.i("Mintegral reloadInterstitialAdvert");
        this.callback = callback;
        if (mMtgInterstitalVideoHandler != null){
            mMtgInterstitalVideoHandler.load();
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return isLoded;
    }

    public void validateAdsAdapter(Activity activity) {

    }

    @Override
    public String getAdvertCode() {
        return AdConfigMobvista.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AdvertCoreMobVista.getInstance().init(activity);

        String  unitid= Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                AdConfigMobvista.CHANNEL_CODE, AdConfigMobvista.KEY_MOBVISTA_InterstitialUnitId);

//        unitid= "58393";
        if (TextUtils.isEmpty(unitid)){
            YLog.e("Mintegral  InterstitialVideoUnitId未获取到");
            return;
        }
        YLog.i("Mintegral  InterstitialVideo  UniteId :  " +  unitid);
        mMtgInterstitalVideoHandler = new MTGInterstitialVideoHandler(activity, unitid);
        mMtgInterstitalVideoHandler.setInterstitialVideoListener(new InterstitialVideoListener() {

            @Override
            public void onLoadSuccess(String s) {
                YLog.d("Mintegral  onLoadSuccess");
            }

            @Override
            public void onVideoLoadSuccess(String s) {
                YLog.d("Mintegral  onVideoLoadSuccess");
                isLoded = true;
                if(callback != null){
                    callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FINISH, getAdvertCode());
                }
            }

            @Override
            public void onVideoLoadFail(String s) {
                YLog.d("Mintegral  onInterstitialVideoLoadFail ： " + s);
                if(callback != null){
                    callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FAILED, getAdvertCode());
                }
            }

            @Override
            public void onShowFail(String errorMsg) {
                YLog.d("Mintegral  onShowFail=" + errorMsg);
                if(intersititalCallback != null){
                    intersititalCallback.onAdError(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, errorMsg, getAdvertCode());
                }
            }

            @Override
            public void onAdShow() {
                YLog.d("Mintegral  onAdShow");
                if(intersititalCallback != null){
                    intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
                }
            }

            @Override
            public void onAdClose(boolean isCompleteView) {
                YLog.d("Mintegral  onAdClose :" + isCompleteView);

                if(intersititalCallback != null){
                    intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
                }
            }


            @Override
            public void onVideoAdClicked(String unitId) {
                YLog.d("Mintegral  onVideoAdClicked");
                if(intersititalCallback != null){
                    intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLICK, getAdvertCode());
                }
            }

        });

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
