/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.unityads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.unity3d.ads.IUnityAdsListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.metadata.MediationMetaData;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.ads.metadata.PlayerMetaData;
import org.json.JSONObject;

class UnityAdsAdapter
extends AbstractAdapter
implements IUnityAdsListener {
    private static final String VERSION = "4.1.2";
    private Activity mActivity;
    private boolean mDidInit = false;
    private boolean mDidCallLoad = false;
    private final String GAME_ID = "sourceId";
    private final String PLACEMENT_ID = "zoneId";
    private final String CONSENT_GDPR = "gdpr.consent";
    private Boolean mConsentCollectingUserData = null;

    public static UnityAdsAdapter startAdapter(String string) {
        return new UnityAdsAdapter(string);
    }

    private UnityAdsAdapter(String string) {
        super(string);
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData integrationData = new IntegrationData("UnityAds", VERSION);
        integrationData.activities = new String[]{"com.unity3d.ads.adunit.AdUnitActivity", "com.unity3d.ads.adunit.AdUnitSoftwareActivity"};
        return integrationData;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return UnityAds.getVersion();
    }

    public void onResume(Activity activity) {
        this.mActivity = activity;
    }

    protected synchronized void setConsent(boolean bl) {
        if (this.mDidInit) {
            MetaData metaData = new MetaData((Context)this.mActivity);
            metaData.set("gdpr.consent", (Object)bl);
            metaData.commit();
        } else {
            this.mConsentCollectingUserData = bl;
        }
    }

    private synchronized void initSDK(Activity activity, String string, String string2) {
        this.mDidInit = true;
        this.mActivity = activity;
        MediationMetaData mediationMetaData = new MediationMetaData((Context)activity);
        mediationMetaData.setName("IronSource");
        mediationMetaData.setVersion(VERSION);
        mediationMetaData.commit();
        UnityAds.setDebugMode((boolean)false);
        UnityAds.initialize((Activity)activity, (String)string, (IUnityAdsListener)this);
        boolean bl = false;
        try {
            bl = this.isAdaptersDebugEnabled();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        UnityAds.setDebugMode((boolean)bl);
        if (this.mConsentCollectingUserData != null) {
            this.setConsent(this.mConsentCollectingUserData);
        }
    }

    public synchronized void initRewardedVideo(Activity activity, String string, String string2, JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("sourceId"))) {
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("zoneId")) && rewardedVideoSmashListener != null) {
            this.mRewardedVideoPlacementToListenerMap.put(jSONObject.optString("zoneId"), rewardedVideoSmashListener);
        }
        if (!this.mDidInit) {
            this.initSDK(activity, jSONObject.optString("sourceId"), string2);
        } else if (rewardedVideoSmashListener != null) {
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(UnityAds.isReady((String)jSONObject.optString("zoneId")));
        }
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
    }

    public void showRewardedVideo(JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (UnityAds.isReady((String)jSONObject.optString("zoneId"))) {
            if (!TextUtils.isEmpty((CharSequence)this.getDynamicUserId())) {
                PlayerMetaData playerMetaData = new PlayerMetaData((Context)this.mActivity);
                playerMetaData.setServerId(this.getDynamicUserId());
                playerMetaData.commit();
            }
            UnityAds.show((Activity)this.mActivity, (String)jSONObject.optString("zoneId"));
        } else if (rewardedVideoSmashListener != null) {
            rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
        }
    }

    public boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        return UnityAds.isReady((String)jSONObject.optString("zoneId"));
    }

    public synchronized void initInterstitial(Activity activity, String string, String string2, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("sourceId"))) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("zoneId")) && interstitialSmashListener != null) {
            this.mInterstitialPlacementToListenerMap.put(jSONObject.optString("zoneId"), interstitialSmashListener);
        }
        if (!this.mDidInit) {
            this.initSDK(activity, jSONObject.optString("sourceId"), string2);
        }
        if (interstitialSmashListener != null) {
            interstitialSmashListener.onInterstitialInitSuccess();
        }
    }

    public void loadInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (UnityAds.isReady((String)jSONObject.optString("zoneId"))) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialAdReady();
            }
        } else {
            this.mDidCallLoad = true;
        }
    }

    public void showInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (UnityAds.isReady((String)jSONObject.optString("zoneId"))) {
            UnityAds.show((Activity)this.mActivity, (String)jSONObject.optString("zoneId"));
        } else if (interstitialSmashListener != null) {
            interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
        }
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        return UnityAds.isReady((String)jSONObject.optString("zoneId"));
    }

    public void onUnityAdsReady(String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onUnityAdsReady(placementId: " + string + ")", 1);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (this.mRewardedVideoPlacementToListenerMap.get(string) != null) {
                ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAvailabilityChanged(true);
            } else if (this.mInterstitialPlacementToListenerMap.get(string) != null) {
                if (this.mDidCallLoad) {
                    this.mDidCallLoad = false;
                }
                ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdReady();
            }
        }
    }

    public void onUnityAdsStart(String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onUnityAdsStart(placementId: " + string + ")", 1);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (this.mRewardedVideoPlacementToListenerMap.get(string) != null) {
                ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAdOpened();
                ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAdStarted();
            } else if (this.mInterstitialPlacementToListenerMap.get(string) != null) {
                ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdOpened();
                ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdShowSucceeded();
            }
        }
    }

    public void onUnityAdsFinish(String string, UnityAds.FinishState finishState) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onUnityAdsFinish(placementId: " + string + ", finishState: " + finishState + ")", 1);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (this.mRewardedVideoPlacementToListenerMap.get(string) != null) {
                ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAvailabilityChanged(UnityAds.isReady((String)string));
                if (finishState.equals((Object)UnityAds.FinishState.COMPLETED)) {
                    ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAdEnded();
                    ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAdRewarded();
                }
                ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAdClosed();
            } else if (this.mInterstitialPlacementToListenerMap.get(string) != null) {
                ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdClosed();
            }
        }
    }

    public void onUnityAdsError(UnityAds.UnityAdsError unityAdsError, String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onUnityAdsError(errorType: " + unityAdsError + ", errorMessage: " + string + ")", 1);
    }
}

