/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.source;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import java.lang.reflect.Method;

public abstract class Source {
    private static final String OPSTR_SYSTEM_ALERT_WINDOW = "android:system_alert_window";
    private static final int OP_REQUEST_INSTALL_PACKAGES = 66;
    private PackageManager mPackageManager;
    private AppOpsManager mAppOpsManager;
    private int mTargetSdkVersion;

    public abstract Context getContext();

    public abstract void startActivity(Intent var1);

    public abstract void startActivityForResult(Intent var1, int var2);

    public abstract boolean isShowRationalePermission(String var1);

    private int getTargetSdkVersion() {
        if (this.mTargetSdkVersion < 14) {
            this.mTargetSdkVersion = this.getContext().getApplicationInfo().targetSdkVersion;
        }
        return this.mTargetSdkVersion;
    }

    private PackageManager getPackageManager() {
        if (this.mPackageManager == null) {
            this.mPackageManager = this.getContext().getPackageManager();
        }
        return this.mPackageManager;
    }

    private AppOpsManager getAppOpsManager() {
        if (this.mAppOpsManager == null) {
            this.mAppOpsManager = (AppOpsManager)this.getContext().getSystemService("appops");
        }
        return this.mAppOpsManager;
    }

    public final boolean canRequestPackageInstalls() {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            if (this.getTargetSdkVersion() < 26) {
                Class<AppOpsManager> clazz = AppOpsManager.class;
                try {
                    Method method = clazz.getDeclaredMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                    int result = (Integer)method.invoke((Object)this.getAppOpsManager(), 66, Process.myUid(), this.getContext().getPackageName());
                    return result == 0;
                }
                catch (Exception ignored) {
                    return true;
                }
            }
            return this.getPackageManager().canRequestPackageInstalls();
        }
        return true;
    }

    public final boolean canDrawOverlays() {
        if (Build.VERSION.SDK_INT >= 23) {
            Context context = this.getContext();
            int result = this.getAppOpsManager().checkOpNoThrow(OPSTR_SYSTEM_ALERT_WINDOW, Process.myUid(), context.getPackageName());
            return result == 0;
        }
        return true;
    }
}

