/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.runtime;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.yanzhenjie.permission.Setting;
import com.yanzhenjie.permission.runtime.LRequestFactory;
import com.yanzhenjie.permission.runtime.MRequestFactory;
import com.yanzhenjie.permission.runtime.PermissionRequest;
import com.yanzhenjie.permission.runtime.setting.RuntimeSetting;
import com.yanzhenjie.permission.source.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Runtime {
    private static final PermissionRequestFactory FACTORY = Build.VERSION.SDK_INT >= 23 ? new MRequestFactory() : new LRequestFactory();
    private static List<String> sManifestPermissions;
    private Source mSource;

    public Runtime(Source source) {
        this.mSource = source;
    }

    public PermissionRequest permission(String ... permissions) {
        this.checkPermissions(permissions);
        return FACTORY.create(this.mSource).permission(permissions);
    }

    public PermissionRequest permission(String[] ... groups) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : groups) {
            permissionList.addAll(Arrays.asList(group));
        }
        String[] permissions = permissionList.toArray(new String[permissionList.size()]);
        return this.permission(permissions);
    }

    public Setting setting() {
        return new RuntimeSetting(this.mSource);
    }

    private void checkPermissions(String ... permissions) {
        if (sManifestPermissions == null) {
            sManifestPermissions = Runtime.getManifestPermissions(this.mSource.getContext());
        }
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException("Please enter at least one permission.");
        }
        for (String p : permissions) {
            if (sManifestPermissions.contains(p)) continue;
            throw new IllegalStateException(String.format("The permission %1$s is not registered in manifest.xml", p));
        }
    }

    private static List<String> getManifestPermissions(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            String[] permissions = packageInfo.requestedPermissions;
            if (permissions == null || permissions.length == 0) {
                throw new IllegalStateException("You did not register any permissions in the manifest.xml.");
            }
            return Collections.unmodifiableList(Arrays.asList(permissions));
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new AssertionError((Object)"Package name cannot be found.");
        }
    }

    public static interface PermissionRequestFactory {
        public PermissionRequest create(Source var1);
    }
}

