/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.runtime;

import android.content.Context;
import android.util.Log;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.PermissionActivity;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.RequestExecutor;
import com.yanzhenjie.permission.checker.DoubleChecker;
import com.yanzhenjie.permission.checker.PermissionChecker;
import com.yanzhenjie.permission.checker.StandardChecker;
import com.yanzhenjie.permission.runtime.PermissionRequest;
import com.yanzhenjie.permission.source.Source;
import com.yanzhenjie.permission.util.MainExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class MRequest
implements PermissionRequest,
RequestExecutor,
PermissionActivity.RequestListener {
    private static final MainExecutor EXECUTOR = new MainExecutor();
    private static final PermissionChecker STANDARD_CHECKER = new StandardChecker();
    private static final PermissionChecker DOUBLE_CHECKER = new DoubleChecker();
    private Source mSource;
    private String[] mPermissions;
    private Rationale<List<String>> mRationale = new Rationale<List<String>>(){

        @Override
        public void showRationale(Context context, List<String> data, RequestExecutor executor) {
            executor.execute();
        }
    };
    private Action<List<String>> mGranted;
    private Action<List<String>> mDenied;
    private String[] mDeniedPermissions;

    MRequest(Source source) {
        this.mSource = source;
    }

    @Override
    public PermissionRequest permission(String ... permissions) {
        this.mPermissions = permissions;
        return this;
    }

    @Override
    public PermissionRequest rationale(Rationale<List<String>> rationale) {
        this.mRationale = rationale;
        return this;
    }

    @Override
    public PermissionRequest onGranted(Action<List<String>> granted) {
        this.mGranted = granted;
        return this;
    }

    @Override
    public PermissionRequest onDenied(Action<List<String>> denied) {
        this.mDenied = denied;
        return this;
    }

    @Override
    public void start() {
        List<String> deniedList = MRequest.getDeniedPermissions(STANDARD_CHECKER, this.mSource, this.mPermissions);
        this.mDeniedPermissions = deniedList.toArray(new String[deniedList.size()]);
        if (this.mDeniedPermissions.length > 0) {
            List<String> rationaleList = MRequest.getRationalePermissions(this.mSource, this.mDeniedPermissions);
            if (rationaleList.size() > 0) {
                this.mRationale.showRationale(this.mSource.getContext(), rationaleList, this);
            } else {
                this.execute();
            }
        } else {
            this.dispatchCallback();
        }
    }

    @Override
    public void execute() {
        PermissionActivity.requestPermission(this.mSource.getContext(), this.mDeniedPermissions, this);
    }

    @Override
    public void cancel() {
        this.dispatchCallback();
    }

    @Override
    public void onRequestCallback() {
        EXECUTOR.postDelayed(new Runnable(){

            @Override
            public void run() {
                MRequest.this.dispatchCallback();
            }
        }, 100L);
    }

    private void dispatchCallback() {
        List<String> deniedList = MRequest.getDeniedPermissions(DOUBLE_CHECKER, this.mSource, this.mPermissions);
        if (deniedList.isEmpty()) {
            this.callbackSucceed();
        } else {
            this.callbackFailed(deniedList);
        }
    }

    private void callbackSucceed() {
        block3: {
            if (this.mGranted != null) {
                List<String> permissionList = Arrays.asList(this.mPermissions);
                try {
                    this.mGranted.onAction(permissionList);
                }
                catch (Exception e) {
                    Log.e((String)"AndPermission", (String)"Please check the onGranted() method body for bugs.", (Throwable)e);
                    if (this.mDenied == null) break block3;
                    this.mDenied.onAction(permissionList);
                }
            }
        }
    }

    private void callbackFailed(List<String> deniedList) {
        if (this.mDenied != null) {
            this.mDenied.onAction(deniedList);
        }
    }

    private static List<String> getDeniedPermissions(PermissionChecker checker, Source source, String ... permissions) {
        ArrayList<String> deniedList = new ArrayList<String>(1);
        for (String permission : permissions) {
            if (checker.hasPermission(source.getContext(), permission)) continue;
            deniedList.add(permission);
        }
        return deniedList;
    }

    private static List<String> getRationalePermissions(Source source, String ... permissions) {
        ArrayList<String> rationaleList = new ArrayList<String>(1);
        for (String permission : permissions) {
            if (!source.isShowRationalePermission(permission)) continue;
            rationaleList.add(permission);
        }
        return rationaleList;
    }
}

