/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.runtime;

import android.util.Log;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.checker.PermissionChecker;
import com.yanzhenjie.permission.checker.StrictChecker;
import com.yanzhenjie.permission.runtime.PermissionRequest;
import com.yanzhenjie.permission.source.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class LRequest
implements PermissionRequest {
    private static final PermissionChecker CHECKER = new StrictChecker();
    private Source mSource;
    private String[] mPermissions;
    private Action<List<String>> mGranted;
    private Action<List<String>> mDenied;

    LRequest(Source source) {
        this.mSource = source;
    }

    @Override
    public PermissionRequest permission(String ... permissions) {
        this.mPermissions = permissions;
        return this;
    }

    @Override
    public PermissionRequest rationale(Rationale<List<String>> rationale) {
        return this;
    }

    @Override
    public PermissionRequest onGranted(Action<List<String>> granted) {
        this.mGranted = granted;
        return this;
    }

    @Override
    public PermissionRequest onDenied(Action<List<String>> denied) {
        this.mDenied = denied;
        return this;
    }

    @Override
    public void start() {
        List<String> deniedList = LRequest.getDeniedPermissions(this.mSource, this.mPermissions);
        if (deniedList.isEmpty()) {
            this.callbackSucceed();
        } else {
            this.callbackFailed(deniedList);
        }
    }

    private void callbackSucceed() {
        block3: {
            if (this.mGranted != null) {
                List<String> permissionList = Arrays.asList(this.mPermissions);
                try {
                    this.mGranted.onAction(permissionList);
                }
                catch (Exception e) {
                    Log.e((String)"AndPermission", (String)"Please check the onGranted() method body for bugs.", (Throwable)e);
                    if (this.mDenied == null) break block3;
                    this.mDenied.onAction(permissionList);
                }
            }
        }
    }

    private void callbackFailed(List<String> deniedList) {
        if (this.mDenied != null) {
            this.mDenied.onAction(deniedList);
        }
    }

    private static List<String> getDeniedPermissions(Source source, String ... permissions) {
        ArrayList<String> deniedList = new ArrayList<String>(1);
        for (String permission : permissions) {
            if (CHECKER.hasPermission(source.getContext(), permission)) continue;
            deniedList.add(permission);
        }
        return deniedList;
    }
}

