/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.overlay.setting;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import com.yanzhenjie.permission.source.Source;

public class OverlaySettingPage {
    private static final String MARK = Build.MANUFACTURER.toLowerCase();
    private Source mSource;

    public OverlaySettingPage(Source source) {
        this.mSource = source;
    }

    public void start(int requestCode) {
        if (MARK.contains("meizu")) {
            if (!this.meiZuApi(requestCode) && !this.defaultApi(requestCode)) {
                this.appDetailsApi(requestCode);
            }
        } else if (!this.defaultApi(requestCode)) {
            this.appDetailsApi(requestCode);
        }
    }

    private boolean meiZuApi(int requestCode) {
        Intent overlayIntent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
        overlayIntent.putExtra("packageName", this.mSource.getContext().getPackageName());
        overlayIntent.setComponent(new ComponentName("com.meizu.safe", "com.meizu.safe.security.AppSecActivity"));
        try {
            this.mSource.startActivityForResult(overlayIntent, requestCode);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean defaultApi(int requestCode) {
        Intent manageIntent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        manageIntent.setData(Uri.fromParts((String)"package", (String)this.mSource.getContext().getPackageName(), null));
        try {
            this.mSource.startActivityForResult(manageIntent, requestCode);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void appDetailsApi(int requestCode) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.fromParts((String)"package", (String)this.mSource.getContext().getPackageName(), null));
        this.mSource.startActivityForResult(intent, requestCode);
    }
}

