/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.handler;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.error.NotFoundException;
import com.yanzhenjie.andserver.framework.body.StringBody;
import com.yanzhenjie.andserver.framework.cross.CrossOrigin;
import com.yanzhenjie.andserver.framework.handler.MappingAdapter;
import com.yanzhenjie.andserver.framework.handler.MethodHandler;
import com.yanzhenjie.andserver.framework.handler.RequestHandler;
import com.yanzhenjie.andserver.framework.mapping.Addition;
import com.yanzhenjie.andserver.framework.mapping.Mapping;
import com.yanzhenjie.andserver.framework.view.BodyView;
import com.yanzhenjie.andserver.framework.view.View;
import com.yanzhenjie.andserver.http.HttpMethod;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class OptionsHandler
implements MethodHandler {
    public static final String INVALID_CORS_REQUEST = "Invalid CORS request.";
    private List<Mapping> mMappings;
    private Map<Mapping, RequestHandler> mMappingMap;
    private Mapping mMapping;
    private MethodHandler mHandler;

    public OptionsHandler(HttpRequest optionsRequest, List<Mapping> mappings, Map<Mapping, RequestHandler> mappingMap) {
        HttpMethod method;
        Mapping exactMapping;
        this.mMappings = mappings;
        this.mMappingMap = mappingMap;
        this.mMapping = this.mMappings.get(0);
        String requestMethod = optionsRequest.getHeader("Access-Control-Request-Method");
        if (!TextUtils.isEmpty((CharSequence)requestMethod) && (exactMapping = MappingAdapter.findMappingByMethod(this.mMappings, method = HttpMethod.reverse(requestMethod))) != null) {
            this.mMapping = exactMapping;
        }
        this.mHandler = (MethodHandler)this.mMappingMap.get(this.mMapping);
    }

    @Override
    @Nullable
    public Addition getAddition() {
        return this.mHandler.getAddition();
    }

    @Override
    @Nullable
    public CrossOrigin getCrossOrigin() {
        return this.mHandler.getCrossOrigin();
    }

    @Override
    @NonNull
    public Mapping getMapping() {
        return this.mMapping;
    }

    @Override
    public View handle(@NonNull HttpRequest request, @NonNull HttpResponse response) throws Throwable {
        String requestOrigin = request.getHeader("Origin");
        if (TextUtils.isEmpty((CharSequence)requestOrigin)) {
            return this.invalidCORS(response);
        }
        String requestMethodText = request.getHeader("Access-Control-Request-Method");
        if (TextUtils.isEmpty((CharSequence)requestMethodText)) {
            return this.invalidCORS(response);
        }
        HttpMethod requestMethod = HttpMethod.reverse(requestMethodText);
        Mapping mapping = MappingAdapter.findMappingByMethod(this.mMappings, requestMethod);
        if (mapping == null) {
            return this.invalidCORS(response);
        }
        MethodHandler handler = (MethodHandler)this.mMappingMap.get(mapping);
        if (handler == null) {
            throw new NotFoundException();
        }
        CrossOrigin crossOrigin = handler.getCrossOrigin();
        if (crossOrigin == null) {
            return this.invalidCORS(response);
        }
        ArrayList<HttpMethod> allowMethods = new ArrayList<HttpMethod>();
        Collections.addAll(allowMethods, crossOrigin.getMethods());
        List<HttpMethod> mappingMethods = mapping.getMethod().getRuleList();
        if (allowMethods.isEmpty()) {
            allowMethods.addAll(mappingMethods);
        }
        if (!allowMethods.contains((Object)requestMethod)) {
            return this.invalidCORS(response);
        }
        List<String> allowOrigins = Arrays.asList(crossOrigin.getOrigins());
        if (!(allowOrigins.isEmpty() || allowOrigins.contains("*") || allowOrigins.contains(requestOrigin))) {
            return this.invalidCORS(response);
        }
        List<String> allowedHeaders = Arrays.asList(crossOrigin.getAllowedHeaders());
        ArrayList outHeaders = new ArrayList();
        String headerHeadersText = request.getHeader("Access-Control-Request-Headers");
        ArrayList<String> requestHeaders = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)headerHeadersText)) {
            StringTokenizer st = new StringTokenizer(headerHeadersText, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ((token = token.trim()).length() <= 0) continue;
                requestHeaders.add(token);
            }
        }
        if (allowedHeaders.contains("*")) {
            if (requestHeaders.size() > 0) {
                outHeaders.addAll(requestHeaders);
            }
        } else if (allowedHeaders.size() > 0) {
            if (requestHeaders.size() > 0) {
                for (String allowedHeader : allowedHeaders) {
                    for (String requestHeader : requestHeaders) {
                        if (!allowedHeader.equalsIgnoreCase(requestHeader)) continue;
                        outHeaders.add(requestHeader);
                    }
                }
                if (outHeaders.isEmpty()) {
                    return this.invalidCORS(response);
                }
            }
        } else if (requestHeaders.size() > 0) {
            outHeaders.addAll(requestHeaders);
        }
        Object[] exposeHeaders = crossOrigin.getExposedHeaders();
        response.setHeader("Access-Control-Allow-Origin", requestOrigin);
        response.setHeader("Access-Control-Allow-Methods", TextUtils.join((CharSequence)", ", allowMethods));
        if (outHeaders.size() > 0) {
            response.setHeader("Access-Control-Allow-Headers", TextUtils.join((CharSequence)", ", outHeaders));
        }
        if (exposeHeaders.length > 0) {
            response.setHeader("Access-Control-Expose-Headers", TextUtils.join((CharSequence)", ", (Object[])exposeHeaders));
        }
        boolean credentials = crossOrigin.isAllowCredentials();
        response.setHeader("Access-Control-Allow-Credentials", Boolean.toString(credentials));
        long maxAge = crossOrigin.getMaxAge();
        response.setHeader("Access-Control-Max-Age", Long.toString(maxAge));
        response.setHeader("Allow", TextUtils.join((CharSequence)", ", (Object[])HttpMethod.values()));
        response.setHeader("Vary", "Origin");
        return new BodyView(new StringBody("OK"));
    }

    private View invalidCORS(HttpResponse response) {
        response.setStatus(403);
        response.setHeader("Allow", TextUtils.join((CharSequence)", ", (Object[])HttpMethod.values()));
        return new BodyView(new StringBody(INVALID_CORS_REQUEST));
    }

    @Override
    public String getETag(@NonNull HttpRequest request) throws Throwable {
        return this.mHandler.getETag(request);
    }

    @Override
    public long getLastModified(@NonNull HttpRequest request) throws Throwable {
        return this.mHandler.getLastModified(request);
    }
}

