/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.handler;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.framework.ETag;
import com.yanzhenjie.andserver.framework.LastModified;
import com.yanzhenjie.andserver.framework.body.StringBody;
import com.yanzhenjie.andserver.framework.cross.CrossOrigin;
import com.yanzhenjie.andserver.framework.handler.MethodHandler;
import com.yanzhenjie.andserver.framework.mapping.Addition;
import com.yanzhenjie.andserver.framework.mapping.Mapping;
import com.yanzhenjie.andserver.framework.mapping.Path;
import com.yanzhenjie.andserver.framework.view.BodyView;
import com.yanzhenjie.andserver.framework.view.View;
import com.yanzhenjie.andserver.http.HttpMethod;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.HttpResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MappingHandler
implements MethodHandler {
    private final Object mHost;
    private final Mapping mMapping;
    private final Addition mAddition;
    private final CrossOrigin mCrossOrigin;

    public MappingHandler(@NonNull Object host, @NonNull Mapping mapping, @NonNull Addition addition, @Nullable CrossOrigin crossOrigin) {
        this.mHost = host;
        this.mMapping = mapping;
        this.mAddition = addition;
        this.mCrossOrigin = crossOrigin;
    }

    @Override
    public String getETag(@NonNull HttpRequest request) throws Throwable {
        Object o = this.getHost();
        if (o instanceof ETag) {
            return ((ETag)o).getETag(request);
        }
        return null;
    }

    @Override
    public long getLastModified(@NonNull HttpRequest request) throws Throwable {
        Object o = this.getHost();
        if (o instanceof LastModified) {
            return ((LastModified)o).getLastModified(request);
        }
        return -1L;
    }

    @Override
    @NonNull
    public Addition getAddition() {
        return this.mAddition;
    }

    @Override
    @Nullable
    public CrossOrigin getCrossOrigin() {
        return this.mCrossOrigin;
    }

    @Override
    @NonNull
    public Mapping getMapping() {
        return this.mMapping;
    }

    @NonNull
    protected Object getHost() {
        return this.mHost;
    }

    @NonNull
    protected Map<String, String> getPathVariable(@NonNull String httpPath) {
        List<Path.Segment> httpSegments = Path.pathToList(httpPath);
        List<Path.Rule> ruleList = this.mMapping.getPath().getRuleList();
        for (Path.Rule rule : ruleList) {
            List<Path.Segment> segments = rule.getSegments();
            if (httpSegments.size() != segments.size()) continue;
            String path = Path.listToPath(segments);
            if (path.equals(httpPath)) {
                return Collections.emptyMap();
            }
            boolean matches = true;
            boolean isBlurred = false;
            for (int i = 0; i < segments.size(); ++i) {
                Path.Segment segment = segments.get(i);
                boolean blurred = segment.isBlurred();
                boolean bl = isBlurred = isBlurred || blurred;
                if (segment.equals(httpSegments.get(i)) || blurred) continue;
                matches = false;
                break;
            }
            if (!matches || !isBlurred) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < segments.size(); ++i) {
                Path.Segment segment = segments.get(i);
                if (!segment.isBlurred()) continue;
                Path.Segment httpSegment = httpSegments.get(i);
                String key = segment.getValue();
                key = key.substring(1, key.length() - 1);
                map.put(key, httpSegment.getValue());
            }
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public View handle(@NonNull HttpRequest request, @NonNull HttpResponse response) throws Throwable {
        String origin = request.getHeader("Origin");
        if (!TextUtils.isEmpty((CharSequence)origin) && this.mCrossOrigin != null) {
            HttpMethod method = request.getMethod();
            List<HttpMethod> allowMethods = Arrays.asList(this.mCrossOrigin.getMethods());
            if (!allowMethods.isEmpty() && !allowMethods.contains((Object)method)) {
                return this.invalidCORS(response, new HttpMethod[0]);
            }
            response.setHeader("Access-Control-Allow-Origin", origin);
            boolean credentials = this.mCrossOrigin.isAllowCredentials();
            response.setHeader("Access-Control-Allow-Credentials", Boolean.toString(credentials));
            response.setHeader("Vary", "Origin");
        }
        return this.onHandle(request, response);
    }

    private View invalidCORS(HttpResponse response, HttpMethod ... methods) {
        response.setStatus(403);
        if (methods != null && methods.length > 0) {
            response.setHeader("Allow", TextUtils.join((CharSequence)", ", (Object[])methods));
        }
        return new BodyView(new StringBody("Invalid CORS request."));
    }

    protected abstract View onHandle(HttpRequest var1, HttpResponse var2) throws Throwable;
}

