/*
 * Decompiled with CFR 0.152.
 */
package com.yan.compodroid.injectionspack.components.saveinstancestate;

import android.os.Bundle;
import android.util.Pair;
import com.yan.compodroid.core.CompodroidComponent;
import com.yan.compodroid.injectionspack.components.saveinstancestate.SaveInstanceState;
import com.yan.compodroid.injectionspack.utils.ReflectUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Set;

public class SaveInstanceComponent
extends CompodroidComponent<Object> {
    public void restoreInstanceState(Bundle savedInstanceState, Object target) {
        if (savedInstanceState == null) {
            return;
        }
        Set<Field> fieldsToRestore = ReflectUtils.findFields(target.getClass(), SaveInstanceState.class);
        for (Field field : fieldsToRestore) {
            Serializable serializable = savedInstanceState.getSerializable(field.getName());
            ReflectUtils.assignValueToField(target, field, serializable);
        }
    }

    private Pair<String, Serializable> createSaveInstancePair(Field field, Object target) {
        try {
            field.setAccessible(true);
            Serializable value = (Serializable)field.get(target);
            String key = field.getName();
            return new Pair((Object)key, (Object)value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveInstanceState(Bundle outState, Object target) {
        Set<Field> fieldsToSave = ReflectUtils.findFields(target.getClass(), SaveInstanceState.class);
        for (Field field : fieldsToSave) {
            Pair<String, Serializable> pair = this.createSaveInstancePair(field, target);
            if (pair == null) continue;
            outState.putSerializable((String)pair.first, (Serializable)pair.second);
        }
    }

    protected void onAddedToManager() {
    }

    protected void onRemovedFromManager() {
    }
}

