/*
 * Decompiled with CFR 0.152.
 */
package com.yan.compodroid.injectionspack.components;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import com.yan.compodroid.core.activity.CompodroidActivityComponent;
import com.yan.compodroid.injectionspack.utils.ReflectUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Set;

public class ViewInjectionComponent
extends CompodroidActivityComponent<Activity> {
    private final RootViewProvider mRootViewProvider;

    protected void onAddedToManager() {
    }

    protected void onRemovedFromManager() {
    }

    public ViewInjectionComponent(RootViewProvider rootViewProvider) {
        this.mRootViewProvider = rootViewProvider;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Set<Field> annotatedViewFields = ReflectUtils.findFields(((Activity)this.getTarget()).getClass(), InjectView.class);
        for (Field field : annotatedViewFields) {
            int viewId = field.getAnnotation(InjectView.class).value();
            ReflectUtils.assignValueToField(this.getTarget(), field, this.mRootViewProvider.provideRootView().findViewById(viewId));
        }
    }

    public static interface RootViewProvider {
        public View provideRootView();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface InjectView {
        public int value();
    }
}

