/*
 * Decompiled with CFR 0.152.
 */
package com.yan.compodroid.injectionspack.components;

import android.app.Activity;
import android.os.Bundle;
import android.util.Pair;
import com.yan.compodroid.core.activity.CompodroidActivityComponent;
import com.yan.compodroid.injectionspack.utils.ReflectUtils;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Set;

public class SaveInstanceComponent
extends CompodroidActivityComponent<Activity> {
    protected void onAddedToManager() {
    }

    protected void onRemovedFromManager() {
    }

    public void onCreate(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        Set<Field> fieldsToRestore = ReflectUtils.findFields(((Activity)this.getTarget()).getClass(), SaveInstanceState.class);
        for (Field field : fieldsToRestore) {
            Serializable serializable = savedInstanceState.getSerializable(field.getName());
            ReflectUtils.assignValueToField(this.getTarget(), field, serializable);
        }
    }

    private Pair<String, Serializable> createSaveInstancePair(Field field) {
        try {
            field.setAccessible(true);
            Serializable value = (Serializable)field.get(this.getTarget());
            String key = field.getName();
            return new Pair((Object)key, (Object)value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        Set<Field> fieldsToSave = ReflectUtils.findFields(((Activity)this.getTarget()).getClass(), SaveInstanceState.class);
        for (Field field : fieldsToSave) {
            Pair<String, Serializable> pair = this.createSaveInstancePair(field);
            if (pair == null) continue;
            outState.putSerializable((String)pair.first, (Serializable)pair.second);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SaveInstanceState {
    }
}

