/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.spring;

import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ClassUtils;

public abstract class AbstractProxyingBeanPostProcessor
extends ProxyConfig
implements BeanPostProcessor {
    private static final long serialVersionUID = -3482052668071169769L;
    private final ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public abstract MethodInterceptor getMethodInterceptor(Class<?> var1);

    public abstract Pointcut getPointcut();

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AopInfrastructureBean) {
            return bean;
        }
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        Pointcut pointcut = this.getPointcut();
        if (AopUtils.canApply((Pointcut)pointcut, (Class)targetClass)) {
            MethodInterceptor interceptor = this.getMethodInterceptor(targetClass);
            DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor(pointcut, (Advice)interceptor);
            if (bean instanceof Advised) {
                ((Advised)bean).addAdvisor(0, (Advisor)advisor);
                return bean;
            }
            ProxyFactory proxyFactory = new ProxyFactory(bean);
            proxyFactory.copyFrom((ProxyConfig)this);
            proxyFactory.addAdvisor((Advisor)advisor);
            return proxyFactory.getProxy(this.beanClassLoader);
        }
        return bean;
    }
}

