/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import com.yalantis.ucrop.R;
import com.yalantis.ucrop.util.BitmapLoadUtils;
import com.yalantis.ucrop.util.SelectedStateListDrawable;
import com.yalantis.ucrop.view.GestureCropImageView;
import com.yalantis.ucrop.view.OverlayView;
import com.yalantis.ucrop.view.TransformImageView;
import com.yalantis.ucrop.view.UCropView;
import com.yalantis.ucrop.view.widget.AspectRatioTextView;
import com.yalantis.ucrop.view.widget.HorizontalProgressWheelView;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UCropActivity
extends AppCompatActivity {
    public static final int DEFAULT_COMPRESS_QUALITY = 90;
    public static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    public static final int NONE = 0;
    public static final int SCALE = 1;
    public static final int ROTATE = 2;
    public static final int ALL = 3;
    private static final String TAG = "UCropActivity";
    private static final int TABS_COUNT = 3;
    private static final int SCALE_WIDGET_SENSITIVITY_COEFFICIENT = 15000;
    private static final int ROTATE_WIDGET_SENSITIVITY_COEFFICIENT = 42;
    private String mToolbarTitle;
    private int mToolbarColor;
    private int mStatusBarColor;
    private int mActiveWidgetColor;
    private int mToolbarTextColor;
    private int mLogoColor;
    private UCropView mUCropView;
    private GestureCropImageView mGestureCropImageView;
    private OverlayView mOverlayView;
    private ViewGroup mWrapperStateAspectRatio;
    private ViewGroup mWrapperStateRotate;
    private ViewGroup mWrapperStateScale;
    private ViewGroup mLayoutAspectRatio;
    private ViewGroup mLayoutRotate;
    private ViewGroup mLayoutScale;
    private List<ViewGroup> mCropAspectRatioViews = new ArrayList<ViewGroup>();
    private TextView mTextViewRotateAngle;
    private TextView mTextViewScalePercent;
    private Uri mOutputUri;
    private Bitmap.CompressFormat mCompressFormat = DEFAULT_COMPRESS_FORMAT;
    private int mCompressQuality = 90;
    private int[] mAllowedGestures = new int[]{1, 2, 3};
    private TransformImageView.TransformImageListener mImageListener = new TransformImageView.TransformImageListener(){

        @Override
        public void onRotate(float currentAngle) {
            UCropActivity.this.setAngleText(currentAngle);
        }

        @Override
        public void onScale(float currentScale) {
            UCropActivity.this.setScaleText(currentScale);
        }

        @Override
        public void onLoadComplete() {
            View ucropView = UCropActivity.this.findViewById(R.id.ucrop);
            Animation fadeInAnimation = AnimationUtils.loadAnimation((Context)UCropActivity.this.getApplicationContext(), (int)R.anim.ucrop_fade_in);
            fadeInAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    UCropActivity.this.mUCropView.setVisibility(0);
                }

                public void onAnimationEnd(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            ucropView.startAnimation(fadeInAnimation);
        }

        @Override
        public void onLoadFailure(@NonNull Exception e) {
            UCropActivity.this.setResultException(e);
            UCropActivity.this.finish();
        }
    };
    private final View.OnClickListener mStateClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!v.isSelected()) {
                UCropActivity.this.setWidgetState(v.getId());
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.ucrop_activity_photobox);
        this.setupViews();
        this.setImageData();
        this.setInitialState();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.ucrop_menu_activity, menu2);
        MenuItem next = menu2.findItem(R.id.menu_crop);
        Drawable defaultIcon = next.getIcon();
        if (defaultIcon != null) {
            defaultIcon.mutate();
            defaultIcon.setColorFilter(this.mToolbarTextColor, PorterDuff.Mode.SRC_ATOP);
            next.setIcon(defaultIcon);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.menu_crop) {
            this.cropAndSaveImage();
        } else if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onStop() {
        super.onStop();
        if (this.mGestureCropImageView != null) {
            this.mGestureCropImageView.cancelAllAnimations();
        }
    }

    private void setImageData() {
        Intent intent = this.getIntent();
        Uri inputUri = (Uri)intent.getParcelableExtra("com.yalantis.ucrop.InputUri");
        this.mOutputUri = (Uri)intent.getParcelableExtra("com.yalantis.ucrop.OutputUri");
        this.processOptions(intent);
        if (inputUri != null && this.mOutputUri != null) {
            try {
                this.mGestureCropImageView.setImageUri(inputUri);
            }
            catch (Exception e) {
                this.setResultException(e);
                this.finish();
            }
        } else {
            this.setResultException(new NullPointerException(this.getString(R.string.ucrop_error_input_data_is_absent)));
            this.finish();
        }
        if (intent.getBooleanExtra("com.yalantis.ucrop.AspectRatioSet", false)) {
            this.mWrapperStateAspectRatio.setVisibility(8);
            float aspectRatioX = intent.getFloatExtra("com.yalantis.ucrop.AspectRatioX", 0.0f);
            float aspectRatioY = intent.getFloatExtra("com.yalantis.ucrop.AspectRatioY", 0.0f);
            if (aspectRatioX > 0.0f && aspectRatioY > 0.0f) {
                this.mGestureCropImageView.setTargetAspectRatio(aspectRatioX / aspectRatioY);
            } else {
                this.mGestureCropImageView.setTargetAspectRatio(0.0f);
            }
        }
        if (intent.getBooleanExtra("com.yalantis.ucrop.MaxSizeSet", false)) {
            int maxSizeX = intent.getIntExtra("com.yalantis.ucrop.MaxSizeX", 0);
            int maxSizeY = intent.getIntExtra("com.yalantis.ucrop.MaxSizeY", 0);
            if (maxSizeX > 0 && maxSizeY > 0) {
                this.mGestureCropImageView.setMaxResultImageSizeX(maxSizeX);
                this.mGestureCropImageView.setMaxResultImageSizeY(maxSizeY);
            } else {
                Log.w((String)TAG, (String)"EXTRA_MAX_SIZE_X and EXTRA_MAX_SIZE_Y must be greater than 0");
            }
        }
    }

    private void processOptions(@NonNull Intent intent) {
        Bundle optionsBundle = intent.getBundleExtra("com.yalantis.ucrop.Options");
        if (optionsBundle != null) {
            String compressionFormatName = optionsBundle.getString("com.yalantis.ucrop.CompressionFormatName");
            Bitmap.CompressFormat compressFormat = null;
            if (!TextUtils.isEmpty((CharSequence)compressionFormatName)) {
                compressFormat = Bitmap.CompressFormat.valueOf((String)compressionFormatName);
            }
            this.mCompressFormat = compressFormat == null ? DEFAULT_COMPRESS_FORMAT : compressFormat;
            this.mCompressQuality = optionsBundle.getInt("com.yalantis.ucrop.CompressionQuality", 90);
            int[] allowedGestures = optionsBundle.getIntArray("com.yalantis.ucrop.AllowedGestures");
            if (allowedGestures != null && allowedGestures.length == 3) {
                this.mAllowedGestures = allowedGestures;
            }
            this.mGestureCropImageView.setMaxBitmapSize(optionsBundle.getInt("com.yalantis.ucrop.MaxBitmapSize", 0));
            this.mGestureCropImageView.setMaxScaleMultiplier(optionsBundle.getFloat("com.yalantis.ucrop.MaxScaleMultiplier", 10.0f));
            this.mGestureCropImageView.setImageToWrapCropBoundsAnimDuration(optionsBundle.getInt("com.yalantis.ucrop.ImageToCropBoundsAnimDuration", 500));
            this.mOverlayView.setDimmedColor(optionsBundle.getInt("com.yalantis.ucrop.DimmedLayerColor", this.getResources().getColor(R.color.ucrop_color_default_dimmed)));
            this.mOverlayView.setOvalDimmedLayer(optionsBundle.getBoolean("com.yalantis.ucrop.OvalDimmedLayer", false));
            this.mOverlayView.setShowCropFrame(optionsBundle.getBoolean("com.yalantis.ucrop.ShowCropFrame", true));
            this.mOverlayView.setCropFrameColor(optionsBundle.getInt("com.yalantis.ucrop.CropFrameColor", this.getResources().getColor(R.color.ucrop_color_default_crop_frame)));
            this.mOverlayView.setCropFrameStrokeWidth(optionsBundle.getInt("com.yalantis.ucrop.CropFrameStrokeWidth", this.getResources().getDimensionPixelSize(R.dimen.ucrop_default_crop_frame_stoke_width)));
            this.mOverlayView.setShowCropGrid(optionsBundle.getBoolean("com.yalantis.ucrop.ShowCropGrid", true));
            this.mOverlayView.setCropGridRowCount(optionsBundle.getInt("com.yalantis.ucrop.CropGridRowCount", 2));
            this.mOverlayView.setCropGridColumnCount(optionsBundle.getInt("com.yalantis.ucrop.CropGridColumnCount", 2));
            this.mOverlayView.setCropGridColor(optionsBundle.getInt("com.yalantis.ucrop.CropGridColor", this.getResources().getColor(R.color.ucrop_color_default_crop_grid)));
            this.mOverlayView.setCropGridStrokeWidth(optionsBundle.getInt("com.yalantis.ucrop.CropGridStrokeWidth", this.getResources().getDimensionPixelSize(R.dimen.ucrop_default_crop_grid_stoke_width)));
        }
    }

    private void setupViews() {
        Bundle optionsBundle = this.getIntent().getBundleExtra("com.yalantis.ucrop.Options");
        this.mStatusBarColor = optionsBundle.getInt("com.yalantis.ucrop.StatusBarColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_statusbar));
        this.mToolbarColor = optionsBundle.getInt("com.yalantis.ucrop.ToolbarColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_toolbar));
        this.mActiveWidgetColor = optionsBundle.getInt("com.yalantis.ucrop.UcropColorWidgetActive", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_widget_active));
        this.mToolbarTextColor = optionsBundle.getInt("com.yalantis.ucrop.UcropToolbarTitleColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_title));
        this.mToolbarTitle = optionsBundle.getString("com.yalantis.ucrop.UcropToolbarTitleText");
        this.mToolbarTitle = !TextUtils.isEmpty((CharSequence)this.mToolbarTitle) ? this.mToolbarTitle : this.getResources().getString(R.string.ucrop_label_edit_photo);
        this.mLogoColor = optionsBundle.getInt("com.yalantis.ucrop.UcropLogoColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_default_logo));
        this.setupAppBar();
        this.initiateRootViews();
        this.setupAspectRatioWidget();
        this.setupRotateWidget();
        this.setupScaleWidget();
        this.setupStatesWrapper();
    }

    private void setupAppBar() {
        this.setStatusBarColor(this.mStatusBarColor);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        toolbar.setBackgroundColor(this.mToolbarColor);
        toolbar.setTitleTextColor(this.mToolbarTextColor);
        TextView toolbarTitle = (TextView)toolbar.findViewById(R.id.toolbar_title);
        toolbarTitle.setTextColor(this.mToolbarTextColor);
        toolbarTitle.setText((CharSequence)this.mToolbarTitle);
        Drawable stateButtonDrawable = ContextCompat.getDrawable((Context)this, (int)R.drawable.ucrop_ic_cross).mutate();
        stateButtonDrawable.setColorFilter(this.mToolbarTextColor, PorterDuff.Mode.SRC_ATOP);
        toolbar.setNavigationIcon(stateButtonDrawable);
        this.setSupportActionBar(toolbar);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayShowTitleEnabled(false);
        }
    }

    private void initiateRootViews() {
        this.mUCropView = (UCropView)this.findViewById(R.id.ucrop);
        this.mGestureCropImageView = this.mUCropView.getCropImageView();
        this.mOverlayView = this.mUCropView.getOverlayView();
        this.mGestureCropImageView.setTransformImageListener(this.mImageListener);
        this.mWrapperStateAspectRatio = (ViewGroup)this.findViewById(R.id.state_aspect_ratio);
        this.mWrapperStateAspectRatio.setOnClickListener(this.mStateClickListener);
        this.mWrapperStateRotate = (ViewGroup)this.findViewById(R.id.state_rotate);
        this.mWrapperStateRotate.setOnClickListener(this.mStateClickListener);
        this.mWrapperStateScale = (ViewGroup)this.findViewById(R.id.state_scale);
        this.mWrapperStateScale.setOnClickListener(this.mStateClickListener);
        this.mLayoutAspectRatio = (ViewGroup)this.findViewById(R.id.layout_aspect_ratio);
        this.mLayoutRotate = (ViewGroup)this.findViewById(R.id.layout_rotate_wheel);
        this.mLayoutScale = (ViewGroup)this.findViewById(R.id.layout_scale_wheel);
        ((ImageView)this.findViewById(R.id.image_view_logo)).setColorFilter(this.mLogoColor, PorterDuff.Mode.SRC_ATOP);
    }

    private void setupStatesWrapper() {
        ImageView stateScaleImageView = (ImageView)this.findViewById(R.id.image_view_state_scale);
        ImageView stateRotateImageView = (ImageView)this.findViewById(R.id.image_view_state_rotate);
        ImageView stateAspectRatioImageView = (ImageView)this.findViewById(R.id.image_view_state_aspect_ratio);
        stateScaleImageView.setImageDrawable((Drawable)new SelectedStateListDrawable(stateScaleImageView.getDrawable(), this.mActiveWidgetColor));
        stateRotateImageView.setImageDrawable((Drawable)new SelectedStateListDrawable(stateRotateImageView.getDrawable(), this.mActiveWidgetColor));
        stateAspectRatioImageView.setImageDrawable((Drawable)new SelectedStateListDrawable(stateAspectRatioImageView.getDrawable(), this.mActiveWidgetColor));
    }

    @TargetApi(value=21)
    private void setStatusBarColor(@ColorInt int color2) {
        if (Build.VERSION.SDK_INT >= 21 && this.getWindow() != null) {
            this.getWindow().setStatusBarColor(color2);
        }
    }

    private void setupAspectRatioWidget() {
        ((AspectRatioTextView)((ViewGroup)this.findViewById(R.id.crop_aspect_ratio_1_1)).getChildAt(0)).setActiveColor(this.mActiveWidgetColor);
        ((AspectRatioTextView)((ViewGroup)this.findViewById(R.id.crop_aspect_ratio_3_4)).getChildAt(0)).setActiveColor(this.mActiveWidgetColor);
        ((AspectRatioTextView)((ViewGroup)this.findViewById(R.id.crop_aspect_ratio_original)).getChildAt(0)).setActiveColor(this.mActiveWidgetColor);
        ((AspectRatioTextView)((ViewGroup)this.findViewById(R.id.crop_aspect_ratio_3_2)).getChildAt(0)).setActiveColor(this.mActiveWidgetColor);
        ((AspectRatioTextView)((ViewGroup)this.findViewById(R.id.crop_aspect_ratio_16_9)).getChildAt(0)).setActiveColor(this.mActiveWidgetColor);
        this.mCropAspectRatioViews.add((ViewGroup)this.findViewById(R.id.crop_aspect_ratio_1_1));
        this.mCropAspectRatioViews.add((ViewGroup)this.findViewById(R.id.crop_aspect_ratio_3_4));
        this.mCropAspectRatioViews.add((ViewGroup)this.findViewById(R.id.crop_aspect_ratio_original));
        this.mCropAspectRatioViews.add((ViewGroup)this.findViewById(R.id.crop_aspect_ratio_3_2));
        this.mCropAspectRatioViews.add((ViewGroup)this.findViewById(R.id.crop_aspect_ratio_16_9));
        this.mCropAspectRatioViews.get(2).setSelected(true);
        for (ViewGroup cropAspectRatioView : this.mCropAspectRatioViews) {
            cropAspectRatioView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    UCropActivity.this.mGestureCropImageView.setTargetAspectRatio(((AspectRatioTextView)((ViewGroup)v).getChildAt(0)).getAspectRatio(v.isSelected()));
                    UCropActivity.this.mGestureCropImageView.setImageToWrapCropBounds();
                    if (!v.isSelected()) {
                        Iterator i$ = UCropActivity.this.mCropAspectRatioViews.iterator();
                        while (i$.hasNext()) {
                            ViewGroup cropAspectRatioView;
                            cropAspectRatioView.setSelected((cropAspectRatioView = (ViewGroup)i$.next()) == v);
                        }
                    }
                }
            });
        }
    }

    private void setupRotateWidget() {
        this.mTextViewRotateAngle = (TextView)this.findViewById(R.id.text_view_rotate);
        ((HorizontalProgressWheelView)this.findViewById(R.id.rotate_scroll_wheel)).setScrollingListener(new HorizontalProgressWheelView.ScrollingListener(){

            @Override
            public void onScroll(float delta, float totalDistance) {
                UCropActivity.this.mGestureCropImageView.postRotate(delta / 42.0f);
            }

            @Override
            public void onScrollEnd() {
                UCropActivity.this.mGestureCropImageView.setImageToWrapCropBounds();
            }

            @Override
            public void onScrollStart() {
                UCropActivity.this.mGestureCropImageView.cancelAllAnimations();
            }
        });
        ((HorizontalProgressWheelView)this.findViewById(R.id.rotate_scroll_wheel)).setMiddleLineColor(this.mActiveWidgetColor);
        this.findViewById(R.id.wrapper_reset_rotate).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UCropActivity.this.resetRotation();
            }
        });
        this.findViewById(R.id.wrapper_rotate_by_angle).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UCropActivity.this.rotateByAngle(90);
            }
        });
    }

    private void setupScaleWidget() {
        this.mTextViewScalePercent = (TextView)this.findViewById(R.id.text_view_scale);
        ((HorizontalProgressWheelView)this.findViewById(R.id.scale_scroll_wheel)).setScrollingListener(new HorizontalProgressWheelView.ScrollingListener(){

            @Override
            public void onScroll(float delta, float totalDistance) {
                if (delta > 0.0f) {
                    UCropActivity.this.mGestureCropImageView.zoomInImage(UCropActivity.this.mGestureCropImageView.getCurrentScale() + delta * ((UCropActivity.this.mGestureCropImageView.getMaxScale() - UCropActivity.this.mGestureCropImageView.getMinScale()) / 15000.0f));
                } else {
                    UCropActivity.this.mGestureCropImageView.zoomOutImage(UCropActivity.this.mGestureCropImageView.getCurrentScale() + delta * ((UCropActivity.this.mGestureCropImageView.getMaxScale() - UCropActivity.this.mGestureCropImageView.getMinScale()) / 15000.0f));
                }
            }

            @Override
            public void onScrollEnd() {
                UCropActivity.this.mGestureCropImageView.setImageToWrapCropBounds();
            }

            @Override
            public void onScrollStart() {
                UCropActivity.this.mGestureCropImageView.cancelAllAnimations();
            }
        });
        ((HorizontalProgressWheelView)this.findViewById(R.id.scale_scroll_wheel)).setMiddleLineColor(this.mActiveWidgetColor);
    }

    private void setAngleText(float angle) {
        if (this.mTextViewRotateAngle != null) {
            this.mTextViewRotateAngle.setText((CharSequence)String.format("%.1f\u00b0", Float.valueOf(angle)));
        }
    }

    private void setScaleText(float scale) {
        if (this.mTextViewScalePercent != null) {
            this.mTextViewScalePercent.setText((CharSequence)String.format("%d%%", (int)(scale * 100.0f)));
        }
    }

    private void resetRotation() {
        this.mGestureCropImageView.postRotate(-this.mGestureCropImageView.getCurrentAngle());
        this.mGestureCropImageView.setImageToWrapCropBounds();
    }

    private void rotateByAngle(int angle) {
        this.mGestureCropImageView.postRotate(angle);
        this.mGestureCropImageView.setImageToWrapCropBounds();
    }

    private void setInitialState() {
        if (this.mWrapperStateAspectRatio.getVisibility() == 0) {
            this.setWidgetState(R.id.state_aspect_ratio);
        } else {
            this.setWidgetState(R.id.state_scale);
        }
    }

    private void setWidgetState(@IdRes int stateViewId) {
        this.mWrapperStateAspectRatio.setSelected(stateViewId == R.id.state_aspect_ratio);
        this.mWrapperStateRotate.setSelected(stateViewId == R.id.state_rotate);
        this.mWrapperStateScale.setSelected(stateViewId == R.id.state_scale);
        this.mLayoutAspectRatio.setVisibility(stateViewId == R.id.state_aspect_ratio ? 0 : 8);
        this.mLayoutRotate.setVisibility(stateViewId == R.id.state_rotate ? 0 : 8);
        this.mLayoutScale.setVisibility(stateViewId == R.id.state_scale ? 0 : 8);
        if (stateViewId == R.id.state_scale) {
            this.setAllowedGestures(0);
        } else if (stateViewId == R.id.state_rotate) {
            this.setAllowedGestures(1);
        } else {
            this.setAllowedGestures(2);
        }
    }

    private void setAllowedGestures(int tab) {
        this.mGestureCropImageView.setScaleEnabled(this.mAllowedGestures[tab] == 3 || this.mAllowedGestures[tab] == 1);
        this.mGestureCropImageView.setRotateEnabled(this.mAllowedGestures[tab] == 3 || this.mAllowedGestures[tab] == 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cropAndSaveImage() {
        OutputStream outputStream = null;
        try {
            Bitmap croppedBitmap = this.mGestureCropImageView.cropImage();
            if (croppedBitmap != null) {
                outputStream = this.getContentResolver().openOutputStream(this.mOutputUri);
                croppedBitmap.compress(this.mCompressFormat, this.mCompressQuality, outputStream);
                croppedBitmap.recycle();
                this.setResultUri(this.mOutputUri, this.mGestureCropImageView.getTargetAspectRatio());
                this.finish();
            } else {
                this.setResultException(new NullPointerException("CropImageView.cropImage() returned null."));
            }
            BitmapLoadUtils.close(outputStream);
        }
        catch (Exception e) {
            this.setResultException(e);
            this.finish();
        }
        finally {
            BitmapLoadUtils.close(outputStream);
        }
    }

    private void setResultUri(Uri uri, float resultAspectRatio) {
        this.setResult(-1, new Intent().putExtra("com.yalantis.ucrop.OutputUri", (Parcelable)uri).putExtra("com.yalantis.ucrop.CropAspectRatio", resultAspectRatio));
    }

    private void setResultException(Throwable throwable) {
        this.setResult(96, new Intent().putExtra("com.yalantis.ucrop.Error", (Serializable)throwable));
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GestureTypes {
    }
}

