/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.yalantis.ucrop.UCropActivity;

public class UCrop {
    public static final int REQUEST_CROP = 69;
    public static final int RESULT_ERROR = 96;
    private static final String EXTRA_PREFIX = "com.yalantis.ucrop";
    public static final String EXTRA_INPUT_URI = "com.yalantis.ucrop.InputUri";
    public static final String EXTRA_OUTPUT_URI = "com.yalantis.ucrop.OutputUri";
    public static final String EXTRA_ERROR = "com.yalantis.ucrop.Error";
    public static final String EXTRA_ASPECT_RATIO_SET = "com.yalantis.ucrop.AspectRatioSet";
    public static final String EXTRA_ASPECT_RATIO_X = "com.yalantis.ucrop.AspectRatioX";
    public static final String EXTRA_ASPECT_RATIO_Y = "com.yalantis.ucrop.AspectRatioY";
    public static final String EXTRA_MAX_SIZE_SET = "com.yalantis.ucrop.MaxSizeSet";
    public static final String EXTRA_MAX_SIZE_X = "com.yalantis.ucrop.MaxSizeX";
    public static final String EXTRA_MAX_SIZE_Y = "com.yalantis.ucrop.MaxSizeY";
    public static final String EXTRA_OPTIONS = "com.yalantis.ucrop.Options";
    private Intent mCropIntent = new Intent();

    public static UCrop of(@NonNull Uri source, @NonNull Uri destination) {
        return new UCrop(source, destination);
    }

    private UCrop(@NonNull Uri source, @NonNull Uri destination) {
        this.mCropIntent.putExtra(EXTRA_INPUT_URI, (Parcelable)source);
        this.mCropIntent.putExtra(EXTRA_OUTPUT_URI, (Parcelable)destination);
    }

    public UCrop withAspectRatio(@IntRange(from=1L) int x, @IntRange(from=1L) int y) {
        this.mCropIntent.putExtra(EXTRA_ASPECT_RATIO_SET, true);
        this.mCropIntent.putExtra(EXTRA_ASPECT_RATIO_X, x);
        this.mCropIntent.putExtra(EXTRA_ASPECT_RATIO_Y, y);
        return this;
    }

    public UCrop useSourceImageAspectRatio() {
        this.mCropIntent.putExtra(EXTRA_ASPECT_RATIO_SET, true);
        this.mCropIntent.putExtra(EXTRA_ASPECT_RATIO_X, 0);
        this.mCropIntent.putExtra(EXTRA_ASPECT_RATIO_Y, 0);
        return this;
    }

    public UCrop withMaxResultSize(@IntRange(from=100L) int width, @IntRange(from=100L) int height) {
        this.mCropIntent.putExtra(EXTRA_MAX_SIZE_SET, true);
        this.mCropIntent.putExtra(EXTRA_MAX_SIZE_X, width);
        this.mCropIntent.putExtra(EXTRA_MAX_SIZE_Y, height);
        return this;
    }

    public UCrop withOptions(@NonNull Options options) {
        this.mCropIntent.putExtra(EXTRA_OPTIONS, options.getOptionBundle());
        return this;
    }

    public void start(@NonNull Activity activity) {
        this.start(activity, 69);
    }

    public void start(@NonNull Activity activity, int requestCode) {
        activity.startActivityForResult(this.getIntent((Context)activity), requestCode);
    }

    public void start(@NonNull Context context, @NonNull Fragment fragment) {
        this.start(context, fragment, 69);
    }

    public void start(@NonNull Context context, @NonNull android.support.v4.app.Fragment fragment) {
        this.start(context, fragment, 69);
    }

    @TargetApi(value=11)
    public void start(@NonNull Context context, @NonNull Fragment fragment, int requestCode) {
        fragment.startActivityForResult(this.getIntent(context), requestCode);
    }

    public void start(@NonNull Context context, @NonNull android.support.v4.app.Fragment fragment, int requestCode) {
        fragment.startActivityForResult(this.getIntent(context), requestCode);
    }

    public Intent getIntent(@NonNull Context context) {
        this.mCropIntent.setClass(context, UCropActivity.class);
        return this.mCropIntent;
    }

    @Nullable
    public static Uri getOutput(@NonNull Intent intent) {
        return (Uri)intent.getParcelableExtra(EXTRA_OUTPUT_URI);
    }

    @Nullable
    public static Throwable getError(@NonNull Intent result) {
        return (Throwable)result.getSerializableExtra(EXTRA_ERROR);
    }

    public static class Options {
        public static final String EXTRA_COMPRESSION_FORMAT_NAME = "com.yalantis.ucrop.CompressionFormatName";
        public static final String EXTRA_COMPRESSION_QUALITY = "com.yalantis.ucrop.CompressionQuality";
        public static final String EXTRA_GESTURES_ALWAYS_ENABLED = "com.yalantis.ucrop.GesturesAlwaysEnabled";
        public static final String EXTRA_MAX_BITMAP_SIZE = "com.yalantis.ucrop.MaxBitmapSize";
        public static final String EXTRA_MAX_SCALE_MULTIPLIER = "com.yalantis.ucrop.MaxScaleMultiplier";
        public static final String EXTRA_IMAGE_TO_CROP_BOUNDS_ANIM_DURATION = "com.yalantis.ucrop.ImageToCropBoundsAnimDuration";
        public static final String EXTRA_DIMMED_LAYER_COLOR = "com.yalantis.ucrop.DimmedLayerColor";
        public static final String EXTRA_OVAL_DIMMED_LAYER = "com.yalantis.ucrop.OvalDimmedLayer";
        public static final String EXTRA_SHOW_CROP_FRAME = "com.yalantis.ucrop.ShowCropFrame";
        public static final String EXTRA_CROP_FRAME_COLOR = "com.yalantis.ucrop.CropFrameColor";
        public static final String EXTRA_CROP_FRAME_STROKE_WIDTH = "com.yalantis.ucrop.CropFrameStrokeWidth";
        public static final String EXTRA_SHOW_CROP_GRID = "com.yalantis.ucrop.ShowCropGrid";
        public static final String EXTRA_CROP_GRID_ROW_COUNT = "com.yalantis.ucrop.CropGridRowCount";
        public static final String EXTRA_CROP_GRID_COLUMN_COUNT = "com.yalantis.ucrop.CropGridColumnCount";
        public static final String EXTRA_CROP_GRID_COLOR = "com.yalantis.ucrop.CropGridColor";
        public static final String EXTRA_CROP_GRID_STROKE_WIDTH = "com.yalantis.ucrop.CropGridStrokeWidth";
        private final Bundle mOptionBundle = new Bundle();

        @NonNull
        public Bundle getOptionBundle() {
            return this.mOptionBundle;
        }

        public void setCompressionFormat(@NonNull Bitmap.CompressFormat format) {
            this.mOptionBundle.putString(EXTRA_COMPRESSION_FORMAT_NAME, format.name());
        }

        public void setCompressionQuality(@IntRange(from=0L) int compressQuality) {
            this.mOptionBundle.putInt(EXTRA_COMPRESSION_QUALITY, compressQuality);
        }

        public void setGesturesAlwaysEnabled(boolean gesturesAlwaysEnabled) {
            this.mOptionBundle.putBoolean(EXTRA_GESTURES_ALWAYS_ENABLED, gesturesAlwaysEnabled);
        }

        public void setMaxScaleMultiplier(@FloatRange(from=1.0, fromInclusive=false) float maxScaleMultiplier) {
            this.mOptionBundle.putFloat(EXTRA_MAX_SCALE_MULTIPLIER, maxScaleMultiplier);
        }

        public void setImageToCropBoundsAnimDuration(@IntRange(from=100L) int durationMillis) {
            this.mOptionBundle.putInt(EXTRA_IMAGE_TO_CROP_BOUNDS_ANIM_DURATION, durationMillis);
        }

        public void setMaxBitmapSize(@IntRange(from=100L) int maxBitmapSize) {
            this.mOptionBundle.putInt(EXTRA_MAX_BITMAP_SIZE, maxBitmapSize);
        }

        public void setDimmedLayerColor(@ColorInt int color) {
            this.mOptionBundle.putInt(EXTRA_DIMMED_LAYER_COLOR, color);
        }

        public void setOvalDimmedLayer(boolean isOval) {
            this.mOptionBundle.putBoolean(EXTRA_OVAL_DIMMED_LAYER, isOval);
        }

        public void setShowCropFrame(boolean show) {
            this.mOptionBundle.putBoolean(EXTRA_SHOW_CROP_FRAME, show);
        }

        public void setCropFrameColor(@ColorInt int color) {
            this.mOptionBundle.putInt(EXTRA_CROP_FRAME_COLOR, color);
        }

        public void setCropFrameStrokeWidth(@IntRange(from=0L) int width) {
            this.mOptionBundle.putInt(EXTRA_CROP_FRAME_STROKE_WIDTH, width);
        }

        public void setShowCropGrid(boolean show) {
            this.mOptionBundle.putBoolean(EXTRA_SHOW_CROP_GRID, show);
        }

        public void setCropGridRowCount(@IntRange(from=0L) int count) {
            this.mOptionBundle.putInt(EXTRA_CROP_GRID_ROW_COUNT, count);
        }

        public void setCropGridColumnCount(@IntRange(from=0L) int count) {
            this.mOptionBundle.putInt(EXTRA_CROP_GRID_COLUMN_COUNT, count);
        }

        public void setCropGridColor(@ColorInt int color) {
            this.mOptionBundle.putInt(EXTRA_CROP_GRID_COLOR, color);
        }

        public void setCropGridStrokeWidth(@IntRange(from=0L) int width) {
            this.mOptionBundle.putInt(EXTRA_CROP_GRID_STROKE_WIDTH, width);
        }
    }
}

