/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;

public class BitmapLoadUtils {
    private static final String TAG = "BitmapLoadUtils";

    @Nullable
    public static Bitmap decode(@NonNull Context context, @Nullable Uri uri, int requiredWidth, int requiredHeight) throws Exception {
        ExifInterface exif;
        if (uri == null) {
            return null;
        }
        ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
        if (parcelFileDescriptor == null) {
            return null;
        }
        FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapLoadUtils.calculateInSampleSize(options, requiredWidth, requiredHeight);
        options.inJustDecodeBounds = false;
        Bitmap decodeSampledBitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        if (Build.VERSION.SDK_INT >= 16) {
            BitmapLoadUtils.close((Closeable)parcelFileDescriptor);
        }
        if ((exif = BitmapLoadUtils.getExif(uri)) != null) {
            int exifOrientation = exif.getAttributeInt("Orientation", 1);
            return BitmapLoadUtils.rotateBitmap(decodeSampledBitmap, BitmapLoadUtils.exifToDegrees(exifOrientation));
        }
        return decodeSampledBitmap;
    }

    public static Bitmap rotateBitmap(@Nullable Bitmap bitmap, int degrees) {
        if (bitmap != null && degrees != 0) {
            Matrix rotateMatrix = new Matrix();
            rotateMatrix.setRotate((float)degrees, (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
            Bitmap converted = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)rotateMatrix, (boolean)true);
            if (bitmap != converted) {
                bitmap.recycle();
                bitmap = converted;
            }
        }
        return bitmap;
    }

    public static int calculateInSampleSize(@NonNull BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            while (height / inSampleSize > reqHeight || width / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    @Nullable
    private static ExifInterface getExif(@NonNull Uri imageUri) {
        try {
            return new ExifInterface(imageUri.getPath());
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"getExif: ", (Throwable)e);
            return null;
        }
    }

    private static int exifToDegrees(int exifOrientation) {
        if (exifOrientation == 6) {
            return 90;
        }
        if (exifOrientation == 3) {
            return 180;
        }
        if (exifOrientation == 8) {
            return 270;
        }
        return 0;
    }

    public static void close(@Nullable Closeable c) {
        if (c != null && c instanceof Closeable) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

