/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.yalantis.ucrop.UCropActivity;

public class UCrop {
    public static final int REQUEST_CROP = 69;
    public static final int RESULT_ERROR = 96;
    public static final String EXTRA_INPUT_URI = "InputUri";
    public static final String EXTRA_OUTPUT_URI = "OutputUri";
    public static final String EXTRA_ERROR = "Error";
    public static final String EXTRA_ASPECT_RATIO_SET = "AspectRatioSet";
    public static final String EXTRA_ASPECT_RATIO_X = "AspectRatioX";
    public static final String EXTRA_ASPECT_RATIO_Y = "AspectRatioY";
    public static final String EXTRA_MAX_SIZE_SET = "MaxSizeSet";
    public static final String EXTRA_MAX_SIZE_X = "MaxSizeX";
    public static final String EXTRA_MAX_SIZE_Y = "MaxSizeY";
    public static final String EXTRA_OPTIONS = "Options";
    private Intent mCropIntent = new Intent();

    public static UCrop of(@NonNull Uri source, @NonNull Uri destination) {
        return new UCrop(source, destination);
    }

    private UCrop(@NonNull Uri source, @NonNull Uri destination) {
        this.mCropIntent.putExtra(EXTRA_INPUT_URI, (Parcelable)source);
        this.mCropIntent.putExtra(EXTRA_OUTPUT_URI, (Parcelable)destination);
    }

    public UCrop withAspectRatio(@IntRange(from=1L) int x, @IntRange(from=1L) int y) {
        this.mCropIntent.putExtra(EXTRA_ASPECT_RATIO_SET, true);
        this.mCropIntent.putExtra(EXTRA_ASPECT_RATIO_X, x);
        this.mCropIntent.putExtra(EXTRA_ASPECT_RATIO_Y, y);
        return this;
    }

    public UCrop useSourceImageAspectRatio() {
        this.mCropIntent.putExtra(EXTRA_ASPECT_RATIO_SET, true);
        this.mCropIntent.putExtra(EXTRA_ASPECT_RATIO_X, 0);
        this.mCropIntent.putExtra(EXTRA_ASPECT_RATIO_Y, 0);
        return this;
    }

    public UCrop withMaxResultSize(@IntRange(from=100L) int width, @IntRange(from=100L) int height) {
        this.mCropIntent.putExtra(EXTRA_MAX_SIZE_SET, true);
        this.mCropIntent.putExtra(EXTRA_MAX_SIZE_X, width);
        this.mCropIntent.putExtra(EXTRA_MAX_SIZE_Y, height);
        return this;
    }

    public UCrop withOptions(@NonNull Options options) {
        this.mCropIntent.putExtra(EXTRA_OPTIONS, (Parcelable)options);
        return this;
    }

    public void start(@NonNull Activity activity) {
        this.start(activity, 69);
    }

    public void start(@NonNull Activity activity, int requestCode) {
        activity.startActivityForResult(this.getIntent((Context)activity), requestCode);
    }

    public void start(@NonNull Context context, @NonNull Fragment fragment) {
        this.start(context, fragment, 69);
    }

    public void start(@NonNull Context context, @NonNull android.support.v4.app.Fragment fragment) {
        this.start(context, fragment, 69);
    }

    @TargetApi(value=11)
    public void start(@NonNull Context context, @NonNull Fragment fragment, int requestCode) {
        fragment.startActivityForResult(this.getIntent(context), requestCode);
    }

    public void start(@NonNull Context context, @NonNull android.support.v4.app.Fragment fragment, int requestCode) {
        fragment.startActivityForResult(this.getIntent(context), requestCode);
    }

    public Intent getIntent(@NonNull Context context) {
        this.mCropIntent.setClass(context, UCropActivity.class);
        return this.mCropIntent;
    }

    @Nullable
    public static Uri getOutput(@NonNull Intent intent) {
        return (Uri)intent.getParcelableExtra(EXTRA_OUTPUT_URI);
    }

    @Nullable
    public static Throwable getError(@NonNull Intent result) {
        return (Throwable)result.getSerializableExtra(EXTRA_ERROR);
    }

    public static class Options
    implements Parcelable {
        private int mMaxBitmapSize;
        private String mCompressionFormatName;
        private int mCompressionQuality;
        private boolean mGesturesAlwaysEnabled;
        public static final Parcelable.Creator<Options> CREATOR = new Parcelable.Creator<Options>(){

            public Options createFromParcel(Parcel in) {
                return new Options(in);
            }

            public Options[] newArray(int size) {
                return new Options[size];
            }
        };

        public Options() {
            this.mMaxBitmapSize = 0;
            this.mCompressionFormatName = UCropActivity.DEFAULT_COMPRESS_FORMAT.name();
            this.mCompressionQuality = 90;
            this.mGesturesAlwaysEnabled = false;
        }

        public void setMaxBitmapSize(@IntRange(from=100L) int maxBitmapSize) {
            this.mMaxBitmapSize = maxBitmapSize;
        }

        public void setCompressionFormat(@NonNull Bitmap.CompressFormat format) {
            this.mCompressionFormatName = format.name();
        }

        public void setCompressionQuality(@IntRange(from=1L) int compressQuality) {
            this.mCompressionQuality = compressQuality;
        }

        public void setGesturesAlwaysEnabled(boolean gesturesAlwaysEnabled) {
            this.mGesturesAlwaysEnabled = gesturesAlwaysEnabled;
        }

        public int getMaxBitmapSize() {
            return this.mMaxBitmapSize;
        }

        public String getCompressionFormatName() {
            return this.mCompressionFormatName;
        }

        public int getCompressionQuality() {
            return this.mCompressionQuality;
        }

        public boolean isGesturesAlwaysEnabled() {
            return this.mGesturesAlwaysEnabled;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mMaxBitmapSize);
            dest.writeString(this.mCompressionFormatName);
            dest.writeInt(this.mCompressionQuality);
            dest.writeByte((byte)(this.mGesturesAlwaysEnabled ? 1 : 0));
        }

        protected Options(Parcel in) {
            this.mMaxBitmapSize = in.readInt();
            this.mCompressionFormatName = in.readString();
            this.mCompressionQuality = in.readInt();
            this.mGesturesAlwaysEnabled = in.readByte() != 0;
        }
    }
}

