/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.yahoo.security.X509SslContext;
import com.yahoo.security.tls.TlsContext;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public class VespaSslContextProvider
implements Supplier<SSLContext> {
    private static TlsContext tlsContext;

    @Override
    public SSLContext get() {
        return this.tlsContext().orElseThrow(() -> new IllegalStateException("Vespa TLS is not enabled")).context();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<X509SslContext> tlsContext() {
        Class<VespaSslContextProvider> clazz = VespaSslContextProvider.class;
        synchronized (VespaSslContextProvider.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Optional.ofNullable(tlsContext.sslContext());
        }
    }

    static synchronized void set(TlsContext ctx) {
        if (tlsContext != null) {
            tlsContext.close();
        }
        tlsContext = ctx;
    }
}

