/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.net.HostName;
import com.yahoo.protect.Process;
import com.yahoo.vespa.zookeeper.Configurator;
import com.yahoo.vespa.zookeeper.ExponentialBackoff;
import com.yahoo.vespa.zookeeper.QuorumPeer;
import com.yahoo.vespa.zookeeper.ReconfigException;
import com.yahoo.vespa.zookeeper.Sleeper;
import com.yahoo.vespa.zookeeper.VespaZooKeeperAdmin;
import com.yahoo.vespa.zookeeper.VespaZooKeeperServer;
import com.yahoo.vespa.zookeeper.ZooKeeperRunner;
import com.yahoo.yolean.Exceptions;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Reconfigurer
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(Reconfigurer.class.getName());
    private static final Duration TIMEOUT = Duration.ofMinutes(3L);
    private final ExponentialBackoff backoff = new ExponentialBackoff(Duration.ofSeconds(1L), Duration.ofSeconds(10L));
    private final VespaZooKeeperAdmin vespaZooKeeperAdmin;
    private final Sleeper sleeper;
    private QuorumPeer peer;
    private ZooKeeperRunner zooKeeperRunner;
    private ZookeeperServerConfig activeConfig;

    @Inject
    public Reconfigurer(VespaZooKeeperAdmin vespaZooKeeperAdmin) {
        this(vespaZooKeeperAdmin, new Sleeper());
    }

    Reconfigurer(VespaZooKeeperAdmin vespaZooKeeperAdmin, Sleeper sleeper) {
        this.vespaZooKeeperAdmin = Objects.requireNonNull(vespaZooKeeperAdmin);
        this.sleeper = Objects.requireNonNull(sleeper);
    }

    public void deconstruct() {
        this.shutdown();
    }

    QuorumPeer startOrReconfigure(ZookeeperServerConfig newConfig, VespaZooKeeperServer server, Supplier<QuorumPeer> quorumPeerCreator) {
        if (this.zooKeeperRunner == null) {
            this.peer = quorumPeerCreator.get();
            this.zooKeeperRunner = this.startServer(newConfig, server);
        }
        if (newConfig.dynamicReconfiguration()) {
            this.reconfigure(newConfig);
        }
        return this.peer;
    }

    ZookeeperServerConfig activeConfig() {
        return this.activeConfig;
    }

    void shutdown() {
        if (this.zooKeeperRunner != null) {
            this.zooKeeperRunner.shutdown();
        }
    }

    private ZooKeeperRunner startServer(ZookeeperServerConfig zookeeperServerConfig, VespaZooKeeperServer server) {
        ZooKeeperRunner runner = new ZooKeeperRunner(zookeeperServerConfig, server);
        this.activeConfig = zookeeperServerConfig;
        return runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconfigure(ZookeeperServerConfig newConfig) {
        Instant reconfigTriggered = Instant.now();
        String newServers = String.join((CharSequence)",", Reconfigurer.servers(newConfig));
        log.log(Level.INFO, "Will reconfigure ZooKeeper cluster.\nServers in active config:" + Reconfigurer.servers(this.activeConfig) + "\nServers in new config:" + Reconfigurer.servers(newConfig));
        String connectionSpec = Reconfigurer.localConnectionSpec(this.activeConfig);
        Instant now = Instant.now();
        Duration reconfigTimeout = Reconfigurer.reconfigTimeout();
        Instant end = now.plus(reconfigTimeout);
        int attempt = 1;
        while (now.isBefore(end)) {
            try {
                Instant reconfigStarted = Instant.now();
                this.vespaZooKeeperAdmin.reconfigure(connectionSpec, newServers);
                Instant reconfigEnded = Instant.now();
                log.log(Level.INFO, "Reconfiguration completed in " + Duration.between(reconfigTriggered, reconfigEnded) + ", after " + attempt + " attempt(s). ZooKeeper reconfig call took " + Duration.between(reconfigStarted, reconfigEnded));
                this.activeConfig = newConfig;
                return;
            }
            catch (ReconfigException e) {
                Duration delay = this.backoff.delay(attempt);
                log.log(Level.WARNING, "Reconfiguration attempt " + attempt + " failed. Retrying in " + delay + ", time left " + Duration.between(now, end) + ": " + Exceptions.toMessageString((Throwable)e));
                this.sleeper.sleep(delay);
            }
            finally {
                now = Instant.now();
            }
            ++attempt;
        }
        this.shutdownAndDie(reconfigTimeout);
    }

    private void shutdownAndDie(Duration reconfigTimeout) {
        this.shutdown();
        Process.logAndDie((String)("Reconfiguration did not complete within timeout " + reconfigTimeout + ". Forcing container shutdown."));
    }

    private static Duration reconfigTimeout() {
        return TIMEOUT;
    }

    private static String localConnectionSpec(ZookeeperServerConfig config) {
        return HostName.getLocalhost() + ":" + config.clientPort();
    }

    private static List<String> servers(ZookeeperServerConfig config) {
        return config.server().stream().filter(server -> !server.retired()).map(server -> Configurator.serverSpec(server, config.clientPort(), false)).collect(Collectors.toList());
    }
}

