/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.auth.X509AuthenticationProvider;

public class VespaMtlsAuthenticationProvider
extends X509AuthenticationProvider {
    private static final Logger log = Logger.getLogger(VespaMtlsAuthenticationProvider.class.getName());

    public VespaMtlsAuthenticationProvider() {
        super(null, null);
    }

    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        X509Certificate[] certificateChain = (X509Certificate[])cnxn.getClientCertificateChain();
        if (certificateChain == null || certificateChain.length == 0) {
            log.warning("Client not authenticated - should not be possible with clientAuth=NEED");
            return KeeperException.Code.AUTHFAILED;
        }
        X509Certificate certificate = certificateChain[0];
        cnxn.addAuthInfo(new Id(this.getScheme(), certificate.getSubjectX500Principal().getName()));
        return KeeperException.Code.OK;
    }
}

