/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper.client;

import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import com.yahoo.vespa.zookeeper.client.VespaSslContextProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class ZkClientConfigBuilder {
    public static final String CLIENT_SECURE_PROPERTY = "zookeeper.client.secure";
    public static final String SSL_CONTEXT_SUPPLIER_CLASS_PROPERTY = "zookeeper.ssl.context.supplier.class";
    public static final String SSL_ENABLED_PROTOCOLS_PROPERTY = "zookeeper.ssl.enabledProtocols";
    public static final String SSL_ENABLED_CIPHERSUITES_PROPERTY = "zookeeper.ssl.ciphersuites";
    public static final String SSL_CLIENTAUTH_PROPERTY = "zookeeper.ssl.clientAuth";
    public static final String CLIENT_CONNECTION_SOCKET = "zookeeper.clientCnxnSocket";
    private static final TlsContext defaultTlsContext = ZkClientConfigBuilder.getTlsContext().orElse(null);
    private final TlsContext tlsContext;

    public ZkClientConfigBuilder() {
        this(defaultTlsContext);
    }

    ZkClientConfigBuilder(TlsContext tlsContext) {
        this.tlsContext = tlsContext;
    }

    public ZKClientConfig toConfig(Path configFile) throws IOException, QuorumPeerConfig.ConfigException {
        String configString = this.toConfigString();
        Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
        Path tempFile = Files.createTempFile(configFile.toAbsolutePath().getParent(), "." + configFile.getFileName(), ".tmp", new FileAttribute[0]);
        Files.writeString(tempFile, (CharSequence)configString, new OpenOption[0]);
        Files.move(tempFile, configFile, StandardCopyOption.ATOMIC_MOVE);
        return new ZKClientConfig(configFile.toString());
    }

    public ZKClientConfig toConfig() {
        ZKClientConfig config = new ZKClientConfig();
        Map<String, String> configProperties = this.toConfigProperties();
        configProperties.forEach((arg_0, arg_1) -> ((ZKClientConfig)config).setProperty(arg_0, arg_1));
        return config;
    }

    public String toConfigString() {
        StringBuilder builder = new StringBuilder();
        Map<String, String> properties = this.toConfigProperties();
        properties.forEach((key, value) -> builder.append((String)key).append('=').append((String)value).append('\n'));
        return builder.toString();
    }

    public Map<String, String> toConfigProperties() {
        HashMap<String, String> builder = new HashMap<String, String>();
        builder.put(CLIENT_SECURE_PROPERTY, Boolean.toString(this.tlsContext != null));
        builder.put(CLIENT_CONNECTION_SOCKET, "org.apache.zookeeper.ClientCnxnSocketNetty");
        if (this.tlsContext != null) {
            builder.put(SSL_CONTEXT_SUPPLIER_CLASS_PROPERTY, VespaSslContextProvider.class.getName());
            String protocolsConfigValue = Arrays.stream(this.tlsContext.parameters().getProtocols()).sorted().collect(Collectors.joining(","));
            builder.put(SSL_ENABLED_PROTOCOLS_PROPERTY, protocolsConfigValue);
            String ciphersConfigValue = Arrays.stream(this.tlsContext.parameters().getCipherSuites()).sorted().collect(Collectors.joining(","));
            builder.put(SSL_ENABLED_CIPHERSUITES_PROPERTY, ciphersConfigValue);
            builder.put(SSL_CLIENTAUTH_PROPERTY, "NEED");
        }
        return Map.copyOf(builder);
    }

    private static Optional<TlsContext> getTlsContext() {
        if (TransportSecurityUtils.getInsecureMixedMode() == MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER) {
            return Optional.empty();
        }
        return TransportSecurityUtils.getSystemTlsContext();
    }
}

