/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.stats;

import com.yahoo.vespa.curator.stats.LatencyMetrics;
import com.yahoo.vespa.curator.stats.LatencyStats;
import java.util.concurrent.atomic.AtomicInteger;

public class LockMetrics {
    private final AtomicInteger acquireCount = new AtomicInteger(0);
    private final AtomicInteger acquireFailedCount = new AtomicInteger(0);
    private final AtomicInteger acquireTimedOutCount = new AtomicInteger(0);
    private final AtomicInteger acquireSucceededCount = new AtomicInteger(0);
    private final AtomicInteger releaseCount = new AtomicInteger(0);
    private final AtomicInteger releaseFailedCount = new AtomicInteger(0);
    private final AtomicInteger reentryCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeAcquireCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeAcquireFailedCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeAcquireTimedOutCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeAcquireSucceededCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeReleaseCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeReleaseFailedCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeReentryCount = new AtomicInteger(0);
    private final LatencyStats acquireStats = new LatencyStats();
    private final LatencyStats lockedStats = new LatencyStats();
    private final AtomicInteger deadlockCount = new AtomicInteger(0);
    private final AtomicInteger acquireWithoutReleaseCount = new AtomicInteger(0);
    private final AtomicInteger nakedReleaseCount = new AtomicInteger(0);
    private final AtomicInteger foreignReleaseCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeDeadlockCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeAcquireWithoutReleaseCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeNakedReleaseCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeForeignReleaseCount = new AtomicInteger(0);

    LatencyStats.ActiveInterval acquireInvoked(boolean reentry) {
        if (reentry) {
            this.reentryCount.incrementAndGet();
            this.cumulativeReentryCount.incrementAndGet();
            return () -> {};
        }
        this.acquireCount.incrementAndGet();
        this.cumulativeAcquireCount.incrementAndGet();
        return this.acquireStats.startNewInterval();
    }

    void acquireFailed(boolean reentry, LatencyStats.ActiveInterval acquireInterval) {
        acquireInterval.close();
        if (reentry) {
            return;
        }
        this.acquireFailedCount.incrementAndGet();
        this.cumulativeAcquireFailedCount.incrementAndGet();
    }

    void acquireTimedOut(boolean reentry, LatencyStats.ActiveInterval acquireInterval) {
        acquireInterval.close();
        if (reentry) {
            return;
        }
        this.acquireTimedOutCount.incrementAndGet();
        this.cumulativeAcquireTimedOutCount.incrementAndGet();
    }

    LatencyStats.ActiveInterval lockAcquired(boolean reentry, LatencyStats.ActiveInterval acquireInterval) {
        acquireInterval.close();
        if (reentry) {
            return () -> {};
        }
        this.acquireSucceededCount.incrementAndGet();
        this.cumulativeAcquireSucceededCount.incrementAndGet();
        return this.lockedStats.startNewInterval();
    }

    void preRelease(boolean reentry, LatencyStats.ActiveInterval lockedInterval) {
        lockedInterval.close();
        if (reentry) {
            return;
        }
        this.releaseCount.incrementAndGet();
        this.cumulativeReleaseCount.incrementAndGet();
    }

    void releaseFailed(boolean reentry) {
        if (reentry) {
            return;
        }
        this.releaseFailedCount.incrementAndGet();
        this.cumulativeReleaseFailedCount.incrementAndGet();
    }

    void incrementDeadlockCount() {
        this.deadlockCount.incrementAndGet();
        this.cumulativeDeadlockCount.incrementAndGet();
    }

    void incrementAcquireWithoutReleaseCount() {
        this.acquireWithoutReleaseCount.incrementAndGet();
        this.cumulativeAcquireWithoutReleaseCount.incrementAndGet();
    }

    void incrementNakedReleaseCount() {
        this.nakedReleaseCount.incrementAndGet();
        this.cumulativeNakedReleaseCount.incrementAndGet();
    }

    void incrementForeignReleaseCount() {
        this.foreignReleaseCount.incrementAndGet();
        this.cumulativeForeignReleaseCount.incrementAndGet();
    }

    public int getAndResetAcquireCount() {
        return this.acquireCount.getAndSet(0);
    }

    public int getAndResetAcquireFailedCount() {
        return this.acquireFailedCount.getAndSet(0);
    }

    public int getAndResetAcquireTimedOutCount() {
        return this.acquireTimedOutCount.getAndSet(0);
    }

    public int getAndResetAcquireSucceededCount() {
        return this.acquireSucceededCount.getAndSet(0);
    }

    public int getAndResetReleaseCount() {
        return this.releaseCount.getAndSet(0);
    }

    public int getAndResetReleaseFailedCount() {
        return this.releaseFailedCount.getAndSet(0);
    }

    public int getAndResetReentryCount() {
        return this.reentryCount.getAndSet(0);
    }

    public int getAndResetDeadlockCount() {
        return this.deadlockCount.getAndSet(0);
    }

    public int getAndResetAcquireWithoutReleaseCount() {
        return this.acquireWithoutReleaseCount.getAndSet(0);
    }

    public int getAndResetNakedReleaseCount() {
        return this.nakedReleaseCount.getAndSet(0);
    }

    public int getAndResetForeignReleaseCount() {
        return this.foreignReleaseCount.getAndSet(0);
    }

    public int getCumulativeAcquireCount() {
        return this.cumulativeAcquireCount.get();
    }

    public int getCumulativeAcquireFailedCount() {
        return this.cumulativeAcquireFailedCount.get();
    }

    public int getCumulativeAcquireTimedOutCount() {
        return this.cumulativeAcquireTimedOutCount.get();
    }

    public int getCumulativeAcquireSucceededCount() {
        return this.cumulativeAcquireSucceededCount.get();
    }

    public int getCumulativeReleaseCount() {
        return this.cumulativeReleaseCount.get();
    }

    public int getCumulativeReleaseFailedCount() {
        return this.cumulativeReleaseFailedCount.get();
    }

    public int getCumulativeReentryCount() {
        return this.cumulativeReentryCount.get();
    }

    public int getCumulativeDeadlockCount() {
        return this.cumulativeDeadlockCount.get();
    }

    public int getCumulativeAcquireWithoutReleaseCount() {
        return this.cumulativeAcquireWithoutReleaseCount.get();
    }

    public int getCumulativeNakedReleaseCount() {
        return this.cumulativeNakedReleaseCount.get();
    }

    public int getCumulativeForeignReleaseCount() {
        return this.cumulativeForeignReleaseCount.get();
    }

    public LatencyMetrics getAcquireLatencyMetrics() {
        return this.acquireStats.getLatencyMetrics();
    }

    public LatencyMetrics getLockedLatencyMetrics() {
        return this.lockedStats.getLatencyMetrics();
    }

    public LatencyMetrics getAndResetAcquireLatencyMetrics() {
        return this.acquireStats.getLatencyMetricsAndStartNewPeriod();
    }

    public LatencyMetrics getAndResetLockedLatencyMetrics() {
        return this.lockedStats.getLatencyMetricsAndStartNewPeriod();
    }

    LockMetrics setAcquireCount(int count) {
        this.acquireCount.set(count);
        return this;
    }

    LockMetrics setAcquireFailedCount(int count) {
        this.acquireFailedCount.set(count);
        return this;
    }

    LockMetrics setAcquireTimedOutCount(int count) {
        this.acquireTimedOutCount.set(count);
        return this;
    }

    LockMetrics setAcquireSucceededCount(int count) {
        this.acquireSucceededCount.set(count);
        return this;
    }

    LockMetrics setReleaseCount(int count) {
        this.releaseCount.set(count);
        return this;
    }

    LockMetrics setReleaseFailedCount(int count) {
        this.releaseFailedCount.set(count);
        return this;
    }

    LockMetrics setReentryCount(int count) {
        this.reentryCount.set(count);
        return this;
    }

    LockMetrics setCumulativeAcquireCount(int count) {
        this.cumulativeAcquireCount.set(count);
        return this;
    }

    LockMetrics setCumulativeAcquireFailedCount(int count) {
        this.cumulativeAcquireFailedCount.set(count);
        return this;
    }

    LockMetrics setCumulativeAcquireTimedOutCount(int count) {
        this.cumulativeAcquireTimedOutCount.set(count);
        return this;
    }

    LockMetrics setCumulativeAcquireSucceededCount(int count) {
        this.cumulativeAcquireSucceededCount.set(count);
        return this;
    }

    LockMetrics setCumulativeReleaseCount(int count) {
        this.cumulativeReleaseCount.set(count);
        return this;
    }

    LockMetrics setCumulativeReleaseFailedCount(int count) {
        this.cumulativeReleaseFailedCount.set(count);
        return this;
    }

    LockMetrics setCumulativeReentryCount(int count) {
        this.cumulativeReentryCount.set(count);
        return this;
    }

    public String toString() {
        return "LockMetrics{acquireCount=" + String.valueOf(this.acquireCount) + ", acquireFailedCount=" + String.valueOf(this.acquireFailedCount) + ", acquireTimedOutCount=" + String.valueOf(this.acquireTimedOutCount) + ", acquireSucceededCount=" + String.valueOf(this.acquireSucceededCount) + ", releaseCount=" + String.valueOf(this.releaseCount) + ", releaseFailedCount=" + String.valueOf(this.releaseFailedCount) + ", reentryCount=" + String.valueOf(this.reentryCount) + ", cumulativeAcquireCount=" + String.valueOf(this.cumulativeAcquireCount) + ", cumulativeAcquireFailedCount=" + String.valueOf(this.cumulativeAcquireFailedCount) + ", cumulativeAcquireTimedOutCount=" + String.valueOf(this.cumulativeAcquireTimedOutCount) + ", cumulativeAcquireSucceededCount=" + String.valueOf(this.cumulativeAcquireSucceededCount) + ", cumulativeReleaseCount=" + String.valueOf(this.cumulativeReleaseCount) + ", cumulativeReleaseFailedCount=" + String.valueOf(this.cumulativeReleaseFailedCount) + ", cumulativeReentryCount=" + String.valueOf(this.cumulativeReentryCount) + ", acquireStats=" + String.valueOf(this.acquireStats) + ", lockedStats=" + String.valueOf(this.lockedStats) + "}";
    }
}

