/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.concurrent.UncheckedTimeoutException;
import com.yahoo.jdisc.Metric;
import com.yahoo.path.Path;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.SingletonManager;
import com.yahoo.vespa.curator.api.VespaCurator;
import com.yahoo.yolean.UncheckedInterruptedException;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class CuratorWrapper
extends AbstractComponent
implements VespaCurator {
    static final Path userRoot = Path.fromString((String)"user");
    private final Curator curator;
    private final SingletonManager singletons;

    @Inject
    public CuratorWrapper(Curator curator, Metric metric) {
        this(curator, Clock.systemUTC(), Duration.ofSeconds(1L), metric);
    }

    CuratorWrapper(Curator curator, Clock clock, Duration tickTimeout, Metric metric) {
        this.curator = curator;
        this.singletons = new SingletonManager(curator, clock, tickTimeout, metric);
        curator.framework().getConnectionStateListenable().addListener((curatorFramework, connectionState) -> {
            if (connectionState == ConnectionState.LOST) {
                this.singletons.invalidate();
            }
        });
    }

    @Override
    public Optional<VespaCurator.Meta> stat(Path path) {
        return this.curator.getStat(userRoot.append(path)).map(stat -> new VespaCurator.Meta(stat.getVersion()));
    }

    @Override
    public Optional<VespaCurator.Data> read(Path path) {
        Stat stat = new Stat();
        return this.curator.getData(userRoot.append(path), stat).map(data -> new VespaCurator.Data(new VespaCurator.Meta(stat.getVersion()), (byte[])data));
    }

    @Override
    public VespaCurator.Meta write(Path path, byte[] data) {
        return new VespaCurator.Meta(this.curator.set(userRoot.append(path), data).getVersion());
    }

    @Override
    public Optional<VespaCurator.Meta> write(Path path, byte[] data, int expectedVersion) {
        try {
            return Optional.of(new VespaCurator.Meta(this.curator.set(userRoot.append(path), data, expectedVersion).getVersion()));
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof KeeperException.BadVersionException) {
                return Optional.empty();
            }
            throw e;
        }
    }

    @Override
    public void deleteAll(Path path) {
        this.curator.delete(userRoot.append(path));
    }

    @Override
    public void delete(Path path) {
        this.curator.delete(userRoot.append(path), false);
    }

    @Override
    public boolean delete(Path path, int expectedVersion) {
        try {
            this.curator.delete(userRoot.append(path), expectedVersion, false);
            return true;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof KeeperException.BadVersionException) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public List<String> list(Path path) {
        return this.curator.getChildren(userRoot.append(path));
    }

    @Override
    public AutoCloseable lock(Path path, Duration timeout) {
        return this.curator.lock(userRoot.append(path), timeout);
    }

    @Override
    public void register(VespaCurator.SingletonWorker singleton, Duration timeout) {
        try {
            this.await(this.singletons.register(singleton.id(), singleton), timeout, "registering " + String.valueOf(singleton));
        }
        catch (RuntimeException e) {
            try {
                this.unregister(singleton, timeout);
            }
            catch (Exception f) {
                e.addSuppressed(f);
            }
            throw e;
        }
    }

    @Override
    public void unregister(VespaCurator.SingletonWorker singleton, Duration timeout) {
        this.await(this.singletons.unregister(singleton), timeout, "unregistering " + String.valueOf(singleton));
    }

    private void await(Future<?> future, Duration timeout, String action) {
        try {
            future.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw new UncheckedInterruptedException("interrupted while " + action, e, true);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new UncheckedTimeoutException("timed out while " + action, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("failed " + action, e.getCause());
        }
    }

    @Override
    public boolean isActive(String singletonId) {
        return this.singletons.isActive(singletonId);
    }

    public void deconstruct() {
        try {
            this.singletons.shutdown().get();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e, true);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

