/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.transaction;

import com.yahoo.path.Path;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.TransactionChanges;
import java.util.Optional;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;

class CuratorCreateOperation
implements CuratorOperation {
    private final String path;
    private final Optional<byte[]> data;

    CuratorCreateOperation(String path, Optional<byte[]> data) {
        this.path = path;
        this.data = data;
    }

    @Override
    public void check(Curator curator, TransactionChanges changes) {
        int lastSlash = this.path.lastIndexOf("/");
        if (lastSlash < 0) {
            return;
        }
        String parent = this.path.substring(0, lastSlash);
        if (!(parent.isEmpty() || curator.exists(Path.fromString((String)parent)) || changes.create(parent))) {
            throw new IllegalStateException("Cannot perform " + String.valueOf(this) + ": Parent '" + parent + "' does not exist");
        }
        changes.addCreate(this.path);
    }

    @Override
    public CuratorTransaction and(CuratorTransaction transaction) throws Exception {
        if (this.data.isPresent()) {
            return ((CuratorTransactionBridge)transaction.create().forPath(this.path, this.data.get())).and();
        }
        return ((CuratorTransactionBridge)transaction.create().forPath(this.path)).and();
    }

    public String toString() {
        return "CREATE " + this.path;
    }
}

