/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.transaction;

import com.yahoo.path.Path;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.TransactionChanges;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;

class CuratorDeleteOperation
implements CuratorOperation {
    private final String path;

    CuratorDeleteOperation(String path) {
        this.path = path;
    }

    @Override
    public void check(Curator curator, TransactionChanges changes) {
        if (!curator.exists(Path.fromString((String)this.path)) && !changes.create(this.path)) {
            throw new IllegalStateException("Cannot perform " + String.valueOf(this) + ": Path does not exist");
        }
        if (this.hasNondeletedChildren(Path.fromString((String)this.path), curator, changes) || changes.createsChildrenOf(this.path)) {
            throw new IllegalStateException("Cannot perform " + String.valueOf(this) + ": Path is not empty");
        }
        changes.addDelete(this.path);
    }

    private boolean hasNondeletedChildren(Path path, Curator curator, TransactionChanges changes) {
        for (String childName : curator.getChildren(path)) {
            if (changes.delete(path.append(childName).getAbsolute())) continue;
            return true;
        }
        return false;
    }

    @Override
    public CuratorTransaction and(CuratorTransaction transaction) throws Exception {
        return ((CuratorTransactionBridge)transaction.delete().forPath(this.path)).and();
    }

    public String toString() {
        return "DELETE " + this.path;
    }
}

