/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.mock;

import com.yahoo.component.annotation.Inject;
import com.yahoo.path.Path;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.mock.MockCuratorFramework;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.framework.recipes.locks.InterProcessLock;

public class MockCurator
extends Curator {
    private String zooKeeperEnsembleConnectionSpec = "";

    @Inject
    public MockCurator() {
        this(true);
    }

    public MockCurator(boolean stableOrdering) {
        super("host1:2181", "host1:2181", retryPolicy -> new MockCuratorFramework(stableOrdering, false));
    }

    private MockCuratorFramework mockFramework() {
        return (MockCuratorFramework)super.framework();
    }

    public Optional<DistributedAtomicLong> counter(String path) {
        return Optional.ofNullable(this.mockFramework().atomicCounters().get(path));
    }

    public void setZooKeeperEnsembleConnectionSpec(String ensembleSpec) {
        this.zooKeeperEnsembleConnectionSpec = ensembleSpec;
    }

    @Override
    public String zooKeeperEnsembleConnectionSpec() {
        return this.zooKeeperEnsembleConnectionSpec;
    }

    @Override
    public DistributedAtomicLong createAtomicCounter(String path) {
        return this.mockFramework().createAtomicCounter(path);
    }

    @Override
    public InterProcessLock createMutex(String path) {
        return this.mockFramework().createMutex(path);
    }

    @Override
    public Curator.CompletionWaiter getCompletionWaiter(Path barrierPath, String id, Duration waitForAll) {
        return this.mockFramework().createCompletionWaiter();
    }

    @Override
    public Curator.CompletionWaiter createCompletionWaiter(Path barrierPath, String id, Duration waitForAll) {
        return this.mockFramework().createCompletionWaiter();
    }

    @Override
    public Curator.DirectoryCache createDirectoryCache(String path, boolean cacheData, boolean dataIsCompressed, ExecutorService executorService) {
        return this.mockFramework().createDirectoryCache(path);
    }

    @Override
    public Curator.FileCache createFileCache(String path, boolean dataIsCompressed) {
        return this.mockFramework().createFileCache(path);
    }

    @Override
    public int zooKeeperEnsembleCount() {
        return 1;
    }
}

