/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.yahoo.path.Path;
import com.yahoo.vespa.curator.CompletionTimeoutException;
import com.yahoo.vespa.curator.Curator;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class CuratorCompletionWaiter
implements Curator.CompletionWaiter {
    private static final Logger log = Logger.getLogger(CuratorCompletionWaiter.class.getName());
    private final Curator curator;
    private final Path barrierPath;
    private final Path waiterNode;
    private final Clock clock;
    private final Duration waitForAll;

    CuratorCompletionWaiter(Curator curator, Path barrierPath, String serverId, Clock clock, Duration waitForAll) {
        this.waiterNode = barrierPath.append(serverId);
        this.curator = curator;
        this.barrierPath = barrierPath;
        this.clock = clock;
        this.waitForAll = waitForAll;
    }

    @Override
    public void awaitCompletion(Duration timeout) {
        List<String> respondents;
        try {
            log.log(Level.FINE, () -> "Synchronizing on barrier " + String.valueOf(this.barrierPath));
            respondents = this.awaitInternal(timeout);
            log.log(Level.FINE, () -> "Done synchronizing on barrier " + String.valueOf(this.barrierPath));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (respondents.size() < this.barrierMemberCount()) {
            throw new CompletionTimeoutException("Timed out waiting for config servers to complete operation (waited for barrier " + String.valueOf(this.barrierPath) + ").Got response from " + String.valueOf(respondents) + ", but need response from at least " + this.barrierMemberCount() + " server(s). Timeout passed as argument was " + timeout.toMillis() + " ms");
        }
    }

    private List<String> awaitInternal(Duration timeout) throws Exception {
        List respondents;
        Instant startTime = this.clock.instant();
        Instant endTime = startTime.plus(timeout);
        Instant gotQuorumTime = Instant.EPOCH;
        do {
            respondents = (List)this.curator.framework().getChildren().forPath(this.barrierPath.getAbsolute());
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, respondents.size() + "/" + this.curator.zooKeeperEnsembleCount() + " responded: " + String.valueOf(respondents) + ", all participants: " + this.curator.zooKeeperEnsembleConnectionSpec());
            }
            if (respondents.size() == this.curator.zooKeeperEnsembleCount()) {
                this.logBarrierCompleted(respondents, startTime);
                break;
            }
            if (respondents.size() >= this.barrierMemberCount()) {
                if (gotQuorumTime.isBefore(startTime)) {
                    gotQuorumTime = this.clock.instant();
                }
                if (Duration.between(this.clock.instant(), gotQuorumTime.plus(this.waitForAll)).isNegative()) {
                    this.logBarrierCompleted(respondents, startTime);
                    break;
                }
            }
            Thread.sleep(100L);
        } while (this.clock.instant().isBefore(endTime));
        return respondents;
    }

    private void logBarrierCompleted(List<String> respondents, Instant startTime) {
        Duration duration = Duration.between(startTime, Instant.now());
        Level level = duration.minus(Duration.ofSeconds(5L)).isNegative() ? Level.FINE : Level.INFO;
        log.log(level, () -> this.barrierCompletedMessage(respondents, duration));
    }

    private String barrierCompletedMessage(List<String> respondents, Duration duration) {
        return String.valueOf(this.barrierPath) + " completed in " + duration.toString() + ", " + respondents.size() + "/" + this.curator.zooKeeperEnsembleCount() + " responded: " + String.valueOf(respondents);
    }

    @Override
    public void notifyCompletion() {
        try {
            this.curator.framework().create().forPath(this.waiterNode.getAbsolute());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "'" + String.valueOf(this.barrierPath) + "', " + this.barrierMemberCount() + " members";
    }

    public static Curator.CompletionWaiter create(Curator curator, Path barrierPath, String id, Duration waitForAll) {
        return new CuratorCompletionWaiter(curator, barrierPath, id, Clock.systemUTC(), waitForAll);
    }

    public static Curator.CompletionWaiter createAndInitialize(Curator curator, Path barrierPath, String id, Duration waitForAll) {
        curator.delete(barrierPath);
        curator.create(barrierPath);
        return new CuratorCompletionWaiter(curator, barrierPath, id, Clock.systemUTC(), waitForAll);
    }

    private int barrierMemberCount() {
        return this.curator.zooKeeperEnsembleCount() / 2 + 1;
    }
}

