/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.stats;

import com.yahoo.vespa.curator.stats.LockAttempt;
import com.yahoo.vespa.curator.stats.LockAttemptSamples;
import com.yahoo.vespa.curator.stats.LockMetrics;
import com.yahoo.vespa.curator.stats.RecordedLockAttempts;
import com.yahoo.vespa.curator.stats.ThreadLockStats;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class LockStats {
    private static final Logger logger = Logger.getLogger(LockStats.class.getName());
    private static LockStats stats = new LockStats();
    private final ConcurrentHashMap<Thread, ThreadLockStats> statsByThread = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Thread> lockPathsHeld = new ConcurrentHashMap();
    private final LockAttemptSamples completedLockAttemptSamples = new LockAttemptSamples(3);
    private static final int MAX_RECORDINGS = 3;
    private final Object interestingRecordingsMonitor = new Object();
    private final PriorityQueue<RecordedLockAttempts> interestingRecordings = new PriorityQueue<RecordedLockAttempts>(3, Comparator.comparing(RecordedLockAttempts::duration));
    private final ConcurrentHashMap<String, LockMetrics> metricsByLockPath = new ConcurrentHashMap();

    public static LockStats getGlobal() {
        return stats;
    }

    public static ThreadLockStats getForCurrentThread() {
        return stats.getForThread(Thread.currentThread());
    }

    public static void clearForTesting() {
        stats = new LockStats();
    }

    private LockStats() {
    }

    public Map<String, LockMetrics> getLockMetricsByPath() {
        return Map.copyOf(this.metricsByLockPath);
    }

    public List<ThreadLockStats> getThreadLockStats() {
        return List.copyOf(this.statsByThread.values());
    }

    public List<LockAttempt> getLockAttemptSamples() {
        return this.completedLockAttemptSamples.asList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecordedLockAttempts> getHistoricRecordings() {
        Object object = this.interestingRecordingsMonitor;
        synchronized (object) {
            return List.copyOf(this.interestingRecordings);
        }
    }

    ThreadLockStats getForThread(Thread thread) {
        return this.statsByThread.computeIfAbsent(thread, ThreadLockStats::new);
    }

    void notifyOfThreadHoldingLock(Thread currentThread, String lockPath) {
        Thread oldThread = this.lockPathsHeld.put(lockPath, currentThread);
        if (oldThread != null) {
            this.getLockMetrics(lockPath).incrementAcquireWithoutReleaseCount();
            logger.warning("Thread " + currentThread.getName() + " reports it has the lock on " + lockPath + ", but thread " + oldThread.getName() + " has not reported it released the lock");
        }
    }

    void notifyOfThreadReleasingLock(Thread currentThread, String lockPath) {
        Thread oldThread = this.lockPathsHeld.remove(lockPath);
        if (oldThread == null) {
            this.getLockMetrics(lockPath).incrementNakedReleaseCount();
            logger.warning("Thread " + currentThread.getName() + " is releasing the lock " + lockPath + ", but nobody owns that lock");
        } else if (oldThread != currentThread) {
            this.getLockMetrics(lockPath).incrementForeignReleaseCount();
            logger.warning("Thread " + currentThread.getName() + " is releasing the lock " + lockPath + ", but it was owned by thread " + oldThread.getName());
        }
    }

    Optional<ThreadLockStats> getThreadLockStatsHolding(String lockPath) {
        return Optional.ofNullable(this.lockPathsHeld.get(lockPath)).map(this.statsByThread::get);
    }

    LockMetrics getLockMetrics(String lockPath) {
        return this.metricsByLockPath.computeIfAbsent(lockPath, __ -> new LockMetrics());
    }

    void maybeSample(LockAttempt lockAttempt) {
        this.completedLockAttemptSamples.maybeSample(lockAttempt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportNewStoppedRecording(RecordedLockAttempts recording) {
        PriorityQueue<RecordedLockAttempts> priorityQueue = this.interestingRecordings;
        synchronized (priorityQueue) {
            if (this.interestingRecordings.size() < 3) {
                this.interestingRecordings.add(recording);
            } else if (recording.duration().compareTo(this.interestingRecordings.peek().duration()) > 0) {
                this.interestingRecordings.poll();
                this.interestingRecordings.add(recording);
            }
        }
    }
}

