/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.stats;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class LatencyMetrics {
    private final Duration latency;
    private final Duration maxLatency;
    private final Duration maxActiveLatency;
    private final double startHz;
    private final double endHz;
    private final Map<String, Double> loadByThread;
    private final double load;
    private final int maxLoad;
    private final int currentLoad;

    public LatencyMetrics(Duration latency, Duration maxLatency, Duration maxActiveLatency, double startHz, double endHz, Map<String, Double> loadByThread, double load, int maxLoad, int currentLoad) {
        this.latency = latency;
        this.maxLatency = maxLatency;
        this.maxActiveLatency = maxActiveLatency;
        this.startHz = startHz;
        this.endHz = endHz;
        this.loadByThread = new TreeMap<String, Double>(loadByThread);
        this.load = load;
        this.maxLoad = maxLoad;
        this.currentLoad = currentLoad;
    }

    public double latencySeconds() {
        return this.secondsWithMillis(this.latency);
    }

    public double maxLatencySeconds() {
        return this.secondsWithMillis(this.maxLatency);
    }

    public double maxActiveLatencySeconds() {
        return this.secondsWithMillis(this.maxActiveLatency);
    }

    public double startHz() {
        return this.roundTo3DecimalPlaces(this.startHz);
    }

    public double endHz() {
        return this.roundTo3DecimalPlaces(this.endHz);
    }

    public Map<String, Double> loadByThread() {
        TreeMap result = new TreeMap();
        this.loadByThread.forEach((name, load) -> result.put(name, this.roundTo3DecimalPlaces((double)load)));
        return Collections.unmodifiableMap(result);
    }

    public double load() {
        return this.roundTo3DecimalPlaces(this.load);
    }

    public int maxLoad() {
        return this.maxLoad;
    }

    public int currentLoad() {
        return this.currentLoad;
    }

    public String toString() {
        return "LatencyMetrics{averageLatency=" + this.latency + ", maxLatency=" + this.maxLatency + ", maxActiveLatency=" + this.maxActiveLatency + ", numIntervalsStarted=" + this.startHz + ", numIntervalsEnded=" + this.endHz + ", load=" + this.load + ", maxLoad=" + this.maxLoad + ", currentLoad=" + this.currentLoad + "}";
    }

    private double secondsWithMillis(Duration duration) {
        return (double)duration.toMillis() / 1000.0;
    }

    private double roundTo3DecimalPlaces(double value) {
        return (double)Math.round(value * 1000.0) / 1000.0;
    }
}

