/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.stats;

import com.yahoo.vespa.curator.stats.LatencyMetrics;
import java.time.Duration;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongSupplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LatencyStats {
    private static Logger logger = Logger.getLogger(LatencyStats.class.getName());
    private final LongSupplier nanoTimeSupplier;
    private final Object monitor = new Object();
    private long startOfPeriodNanos;
    private long endOfPeriodNanos;
    private double cumulativeLoadNanos;
    private final Map<String, Long> cumulativeLoadNanosByThread = new HashMap<String, Long>();
    private Duration cumulativeLatency;
    private Duration maxLatency;
    private int numIntervalsStarted;
    private int numIntervalsEnded;
    private final HashSet<ActiveIntervalInfo> activeIntervals = new HashSet();
    private int maxLoad;

    public LatencyStats() {
        this(System::nanoTime);
    }

    LatencyStats(LongSupplier nanoTimeSupplier) {
        this.nanoTimeSupplier = nanoTimeSupplier;
        this.endOfPeriodNanos = nanoTimeSupplier.getAsLong();
        this.resetForNewPeriod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveInterval startNewInterval() {
        Object object = this.monitor;
        synchronized (object) {
            this.pushEndOfPeriodToNow();
            ActiveIntervalInfo activeIntervalInfo = new ActiveIntervalInfo(this.endOfPeriodNanos);
            this.activeIntervals.add(activeIntervalInfo);
            this.maxLoad = Math.max(this.maxLoad, this.activeIntervals.size());
            ++this.numIntervalsStarted;
            return () -> this.endInterval(activeIntervalInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LatencyMetrics getLatencyMetrics() {
        Object object = this.monitor;
        synchronized (object) {
            this.pushEndOfPeriodToNow();
            return this.makeLatencyMetrics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LatencyMetrics getLatencyMetricsAndStartNewPeriod() {
        Object object = this.monitor;
        synchronized (object) {
            this.pushEndOfPeriodToNow();
            LatencyMetrics metrics = this.makeLatencyMetrics();
            this.resetForNewPeriod();
            return metrics;
        }
    }

    private void resetForNewPeriod() {
        this.startOfPeriodNanos = this.endOfPeriodNanos;
        this.cumulativeLoadNanos = 0.0;
        this.cumulativeLoadNanosByThread.clear();
        this.cumulativeLatency = Duration.ZERO;
        this.maxLatency = Duration.ZERO;
        this.numIntervalsStarted = 0;
        this.numIntervalsEnded = 0;
        this.maxLoad = this.activeIntervals.size();
    }

    private void pushEndOfPeriodToNow() {
        long currentNanos = this.nanoTimeSupplier.getAsLong();
        this.cumulativeLoadNanos += (double)((long)this.activeIntervals.size() * (currentNanos - this.endOfPeriodNanos));
        for (ActiveIntervalInfo activeInterval : this.activeIntervals) {
            this.cumulativeLoadNanosByThread.merge(activeInterval.threadNameTemplate, currentNanos - this.endOfPeriodNanos, Long::sum);
        }
        this.endOfPeriodNanos = currentNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endInterval(ActiveIntervalInfo activeInterval) {
        boolean wasRemoved;
        Object object = this.monitor;
        synchronized (object) {
            this.pushEndOfPeriodToNow();
            wasRemoved = this.activeIntervals.remove(activeInterval);
            Duration latency = Duration.ofNanos(this.endOfPeriodNanos - activeInterval.startOfIntervalNanos());
            this.cumulativeLatency = this.cumulativeLatency.plus(latency);
            if (latency.compareTo(this.maxLatency) > 0) {
                this.maxLatency = latency;
            }
            ++this.numIntervalsEnded;
        }
        if (!wasRemoved) {
            logger.log(Level.WARNING, "Interval of latency stats was closed twice", new IllegalStateException());
        }
    }

    private LatencyMetrics makeLatencyMetrics() {
        double load;
        double endHz;
        double startHz;
        Duration latency = this.numIntervalsEnded <= 0 ? Duration.ZERO : Duration.ofNanos(Math.round((double)this.cumulativeLatency.toNanos() / (double)this.numIntervalsEnded));
        Optional<Duration> maxLatencyFromActiveIntervals = this.activeIntervals.stream().map(ActiveIntervalInfo::startOfIntervalNanos).min(Comparator.comparing(value -> value)).map(startOfIntervalNanos -> Duration.ofNanos(this.endOfPeriodNanos - startOfIntervalNanos));
        Duration maxActiveLatency = maxLatencyFromActiveIntervals.filter(latencyCandidate -> latencyCandidate.compareTo(this.maxLatency) > 0).orElse(this.maxLatency);
        HashMap<String, Double> loadByThread = new HashMap<String, Double>();
        long periodNanos = this.endOfPeriodNanos - this.startOfPeriodNanos;
        if (periodNanos > 0L) {
            double periodSeconds = (double)periodNanos / 1.0E9;
            startHz = (double)this.numIntervalsStarted / periodSeconds;
            endHz = (double)this.numIntervalsEnded / periodSeconds;
            load = this.cumulativeLoadNanos / (double)periodNanos;
            this.cumulativeLoadNanosByThread.forEach((name, threadLoad) -> {
                if (threadLoad > 0L) {
                    loadByThread.put((String)name, (double)threadLoad.longValue() / (double)periodNanos);
                }
            });
        } else {
            endHz = 0.0;
            startHz = 0.0;
            load = this.activeIntervals.size();
            for (ActiveIntervalInfo activeInterval : this.activeIntervals) {
                loadByThread.put(activeInterval.threadNameTemplate, 1.0);
            }
        }
        return new LatencyMetrics(latency, this.maxLatency, maxActiveLatency, startHz, endHz, loadByThread, load, this.maxLoad, this.activeIntervals.size());
    }

    private static class ActiveIntervalInfo {
        private final long startNanos;
        private final String threadNameTemplate = Thread.currentThread().getName().replaceAll("\\d+", "*");

        public ActiveIntervalInfo(long startOfIntervalNanos) {
            this.startNanos = startOfIntervalNanos;
        }

        public long startOfIntervalNanos() {
            return this.startNanos;
        }
    }

    public static interface ActiveInterval
    extends AutoCloseable {
        @Override
        public void close();
    }
}

