/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.stats;

import com.yahoo.vespa.curator.stats.LockAttempt;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class LockAttemptSamples {
    private final int maxSamples;
    private final Object monitor = new Object();
    private final Map<String, LockAttempt> byLockPath;
    private final PriorityQueue<LockAttempt> priorityQueue = new PriorityQueue<LockAttempt>(Comparator.comparing(LockAttempt::getStableTotalDuration));

    LockAttemptSamples(int maxSamples) {
        this.maxSamples = maxSamples;
        this.byLockPath = new HashMap<String, LockAttempt>(maxSamples);
    }

    int size() {
        return this.byLockPath.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean maybeSample(LockAttempt lockAttempt) {
        boolean added;
        Object object = this.monitor;
        synchronized (object) {
            if (this.shouldAdd(lockAttempt)) {
                this.byLockPath.put(lockAttempt.getLockPath(), lockAttempt);
                this.priorityQueue.add(lockAttempt);
                added = true;
            } else {
                added = false;
            }
        }
        if (added) {
            lockAttempt.fillStackTrace();
        }
        return added;
    }

    private boolean shouldAdd(LockAttempt lockAttempt) {
        LockAttempt existingLockAttempt = this.byLockPath.get(lockAttempt.getLockPath());
        if (existingLockAttempt != null) {
            if (LockAttemptSamples.hasLongerDurationThan(lockAttempt, existingLockAttempt)) {
                this.byLockPath.remove(existingLockAttempt.getLockPath());
                this.priorityQueue.remove(existingLockAttempt);
                return true;
            }
            return false;
        }
        if (this.size() < this.maxSamples) {
            return true;
        }
        existingLockAttempt = this.priorityQueue.peek();
        if (LockAttemptSamples.hasLongerDurationThan(lockAttempt, existingLockAttempt)) {
            this.priorityQueue.poll();
            this.byLockPath.remove(existingLockAttempt.getLockPath());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<LockAttempt> asList() {
        Object object = this.monitor;
        synchronized (object) {
            return List.copyOf(this.byLockPath.values());
        }
    }

    private static boolean hasLongerDurationThan(LockAttempt lockAttempt, LockAttempt otherLockAttempt) {
        return lockAttempt.getStableTotalDuration().compareTo(otherLockAttempt.getStableTotalDuration()) > 0;
    }
}

