/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.yahoo.cloud.config.CuratorConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.path.Path;
import com.yahoo.vespa.curator.ConnectionSpec;
import com.yahoo.vespa.curator.CuratorCompletionWaiter;
import com.yahoo.vespa.curator.Lock;
import com.yahoo.vespa.curator.NodeCacheWrapper;
import com.yahoo.vespa.curator.PathChildrenCacheWrapper;
import com.yahoo.vespa.curator.VespaZooKeeperFactory;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.zookeeper.VespaZooKeeperServer;
import com.yahoo.vespa.zookeeper.client.ZkClientConfigBuilder;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.EphemeralType;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class Curator
extends AbstractComponent
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(Curator.class.getName());
    private static final File ZK_CLIENT_CONFIG_FILE = new File(Defaults.getDefaults().underVespaHome("var/zookeeper/conf/zookeeper-client.cfg"));
    static final Duration DEFAULT_ZK_SESSION_TIMEOUT = Duration.ofSeconds(120L);
    private static final Duration ZK_CONNECTION_TIMEOUT = Duration.ofSeconds(30L);
    private static final Duration BASE_SLEEP_TIME = Duration.ofSeconds(1L);
    private static final int MAX_RETRIES = 4;
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new ExponentialBackoffRetry((int)BASE_SLEEP_TIME.toMillis(), 4);
    static final long defaultJuteMaxBuffer = Long.parseLong(System.getProperty("jute.maxbuffer", "52428800"));
    private final CuratorFramework curatorFramework;
    private final ConnectionSpec connectionSpec;
    private final long juteMaxBuffer;
    private final Duration sessionTimeout;
    private final ConcurrentHashMap<Path, Lock> locks = new ConcurrentHashMap();

    public static Curator create(String connectionSpec) {
        return new Curator(ConnectionSpec.create(connectionSpec), Optional.of(ZK_CLIENT_CONFIG_FILE), defaultJuteMaxBuffer, DEFAULT_ZK_SESSION_TIMEOUT);
    }

    public static Curator create(String connectionSpec, Optional<File> clientConfigFile) {
        return new Curator(ConnectionSpec.create(connectionSpec), clientConfigFile, defaultJuteMaxBuffer, DEFAULT_ZK_SESSION_TIMEOUT);
    }

    @Inject
    public Curator(CuratorConfig curatorConfig, VespaZooKeeperServer server) {
        this(ConnectionSpec.create(curatorConfig.server(), CuratorConfig.Server::hostname, CuratorConfig.Server::port, curatorConfig.zookeeperLocalhostAffinity()), Optional.of(ZK_CLIENT_CONFIG_FILE), defaultJuteMaxBuffer, Duration.ofSeconds(curatorConfig.zookeeperSessionTimeoutSeconds()));
    }

    protected Curator(String connectionSpec, String zooKeeperEnsembleConnectionSpec, Function<RetryPolicy, CuratorFramework> curatorFactory) {
        this(ConnectionSpec.create(connectionSpec, zooKeeperEnsembleConnectionSpec), curatorFactory.apply(DEFAULT_RETRY_POLICY), defaultJuteMaxBuffer, DEFAULT_ZK_SESSION_TIMEOUT);
    }

    Curator(ConnectionSpec connectionSpec, Optional<File> clientConfigFile, long juteMaxBuffer, Duration sessionTimeout) {
        this(connectionSpec, CuratorFrameworkFactory.builder().retryPolicy(DEFAULT_RETRY_POLICY).sessionTimeoutMs((int)sessionTimeout.toMillis()).connectionTimeoutMs((int)ZK_CONNECTION_TIMEOUT.toMillis()).connectString(connectionSpec.local()).zookeeperFactory((ZookeeperFactory)new VespaZooKeeperFactory(Curator.createClientConfig(clientConfigFile))).dontUseContainerParents().ensembleTracker(false).build(), juteMaxBuffer, sessionTimeout);
    }

    private Curator(ConnectionSpec connectionSpec, CuratorFramework curatorFramework, long juteMaxBuffer, Duration sessionTimeout) {
        this.connectionSpec = Objects.requireNonNull(connectionSpec);
        this.curatorFramework = Objects.requireNonNull(curatorFramework);
        this.juteMaxBuffer = juteMaxBuffer;
        this.sessionTimeout = sessionTimeout;
        this.addLoggingListener();
        curatorFramework.start();
    }

    private static ZKClientConfig createClientConfig(Optional<File> clientConfigFile) {
        if (clientConfigFile.isPresent()) {
            try {
                return new ZkClientConfigBuilder().toConfig(clientConfigFile.get().toPath());
            }
            catch (QuorumPeerConfig.ConfigException e) {
                throw new RuntimeException("Unable to create ZooKeeper client config file " + clientConfigFile.get());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new ZKClientConfig();
    }

    public Duration sessionTimeout() {
        return this.sessionTimeout;
    }

    public DistributedAtomicLong createAtomicCounter(String path) {
        return new DistributedAtomicLong(this.curatorFramework, path, (RetryPolicy)new ExponentialBackoffRetry((int)BASE_SLEEP_TIME.toMillis(), 4));
    }

    public InterProcessLock createMutex(String lockPath) {
        return new InterProcessMutex(this.curatorFramework, lockPath);
    }

    private void addLoggingListener() {
        this.curatorFramework.getConnectionStateListenable().addListener((curatorFramework, connectionState) -> {
            switch (connectionState) {
                case SUSPENDED: {
                    LOG.info("ZK connection state change: SUSPENDED");
                    break;
                }
                case RECONNECTED: {
                    LOG.info("ZK connection state change: RECONNECTED");
                    break;
                }
                case LOST: {
                    LOG.warning("ZK connection state change: LOST");
                }
            }
        });
    }

    public CompletionWaiter getCompletionWaiter(Path waiterPath, String id, Duration waitForAll) {
        return CuratorCompletionWaiter.create(this, waiterPath, id, waitForAll);
    }

    public CompletionWaiter createCompletionWaiter(Path waiterPath, String id, Duration waitForAll) {
        return CuratorCompletionWaiter.createAndInitialize(this, waiterPath, id, waitForAll);
    }

    public DirectoryCache createDirectoryCache(String path, boolean cacheData, boolean dataIsCompressed, ExecutorService executorService) {
        return new PathChildrenCacheWrapper(this.framework(), path, cacheData, dataIsCompressed, executorService);
    }

    public FileCache createFileCache(String path, boolean dataIsCompressed) {
        return new NodeCacheWrapper(this.framework(), path, dataIsCompressed);
    }

    public boolean exists(Path path) {
        try {
            return this.framework().checkExists().forPath(path.getAbsolute()) != null;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not check existence of " + path.getAbsolute(), e);
        }
    }

    public Stat set(Path path, byte[] data) {
        return this.set(path, data, -1);
    }

    public Stat set(Path path, byte[] data, int expectedVersion) {
        if ((long)data.length > this.juteMaxBuffer) {
            throw new IllegalArgumentException("Cannot not set data at " + path.getAbsolute() + ", " + data.length + " bytes is too much, max number of bytes allowed per node is " + this.juteMaxBuffer);
        }
        if (!this.exists(path)) {
            this.create(path);
        }
        String absolutePath = path.getAbsolute();
        try {
            return (Stat)((BackgroundPathAndBytesable)this.framework().setData().withVersion(expectedVersion)).forPath(absolutePath, data);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set data at " + absolutePath, e);
        }
    }

    public boolean create(Path path) {
        return this.create(path, null);
    }

    public boolean create(Path path, Duration ttl) {
        return this.create(path, ttl, null);
    }

    private boolean create(Path path, Duration ttl, Stat stat) {
        if (this.exists(path)) {
            return false;
        }
        String absolutePath = path.getAbsolute();
        try {
            CreateBuilder b = this.framework().create();
            if (ttl != null) {
                long millis = ttl.toMillis();
                if (millis <= 0L || millis > EphemeralType.TTL.maxValue()) {
                    throw new IllegalArgumentException(ttl.toString());
                }
                b.withTtl(millis).withMode(CreateMode.PERSISTENT_WITH_TTL);
            }
            if (stat == null) {
                b.creatingParentsIfNeeded().forPath(absolutePath, new byte[0]);
            } else {
                ((ACLBackgroundPathAndBytesable)b.creatingParentsIfNeeded().storingStatIn(stat)).forPath(absolutePath, new byte[0]);
            }
        }
        catch (KeeperException.NodeExistsException b) {
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create " + absolutePath, e);
        }
        return true;
    }

    public void createAtomically(Path ... paths) {
        try {
            CuratorTransaction transaction = this.framework().inTransaction();
            for (Path path : paths) {
                if (this.exists(path)) continue;
                transaction = ((CuratorTransactionBridge)transaction.create().forPath(path.getAbsolute(), new byte[0])).and();
            }
            ((CuratorTransactionFinal)transaction).commit();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create " + Arrays.toString(paths), e);
        }
    }

    public void delete(Path path) {
        this.delete(path, true);
    }

    public void delete(Path path, boolean recursive) {
        this.delete(path, -1, recursive);
    }

    public void delete(Path path, int expectedVersion, boolean recursive) {
        try {
            if (recursive) {
                ((BackgroundPathable)((ChildrenDeletable)this.framework().delete().guaranteed()).deletingChildrenIfNeeded().withVersion(expectedVersion)).forPath(path.getAbsolute());
            } else {
                ((BackgroundPathable)((ChildrenDeletable)this.framework().delete().guaranteed()).withVersion(expectedVersion)).forPath(path.getAbsolute());
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new RuntimeException("Could not delete " + path.getAbsolute(), e);
        }
    }

    public List<String> getChildren(Path path) {
        try {
            return (List)this.framework().getChildren().forPath(path.getAbsolute());
        }
        catch (KeeperException.NoNodeException e) {
            return List.of();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get children of " + path.getAbsolute(), e);
        }
    }

    public Optional<byte[]> getData(Path path) {
        return this.getData(path, null);
    }

    public Optional<byte[]> getData(Path path, Stat stat) {
        try {
            return stat == null ? Optional.of((byte[])this.framework().getData().forPath(path.getAbsolute())) : Optional.of((byte[])((WatchPathable)this.framework().getData().storingStatIn(stat)).forPath(path.getAbsolute()));
        }
        catch (KeeperException.NoNodeException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get data at " + path.getAbsolute(), e);
        }
    }

    public Optional<Stat> getStat(Path path) {
        try {
            return Optional.ofNullable((Stat)this.framework().checkExists().forPath(path.getAbsolute()));
        }
        catch (KeeperException.NoNodeException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get data at " + path.getAbsolute(), e);
        }
    }

    public Lock lock(Path path, Duration timeout, Duration ttl) {
        this.create(path, ttl);
        Lock lock = this.locks.computeIfAbsent(path, pathArg -> new Lock(pathArg.getAbsolute(), this));
        lock.acquire(timeout);
        return lock;
    }

    public Lock lock(Path path, Duration timeout) {
        return this.lock(path, timeout, null);
    }

    public CuratorFramework framework() {
        return this.curatorFramework;
    }

    @Override
    public void close() {
        ExecutorService executor;
        block2: {
            executor = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("curator-shutdown"));
            CompletableFuture<Void> shutdown = CompletableFuture.runAsync(() -> ((CuratorFramework)this.curatorFramework).close(), executor);
            try {
                shutdown.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed shutting down curator framework (within 10 seconds)", e);
                if (!(e instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
        executor.shutdownNow();
    }

    public void deconstruct() {
        this.close();
    }

    public String zooKeeperEnsembleConnectionSpec() {
        return this.connectionSpec.ensemble();
    }

    public int zooKeeperEnsembleCount() {
        return this.connectionSpec.ensembleSize();
    }

    public static interface CompletionWaiter {
        public void awaitCompletion(Duration var1);

        public void notifyCompletion();
    }

    public static interface FileCache {
        public void start();

        public void addListener(NodeCacheListener var1);

        public ChildData getCurrentData();

        public void close();
    }

    public static interface DirectoryCache {
        public void start();

        public void addListener(PathChildrenCacheListener var1);

        public List<ChildData> getCurrentData();

        public ChildData getCurrentData(Path var1);

        public void close();
    }
}

