/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.yahoo.net.HostName;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

class ConnectionSpec {
    private final String local;
    private final String ensemble;
    private final int ensembleSize;

    private ConnectionSpec(String local, String ensemble, int ensembleSize) {
        this.local = ConnectionSpec.requireNonEmpty(local, "local spec");
        this.ensemble = ConnectionSpec.requireNonEmpty(ensemble, "ensemble spec");
        this.ensembleSize = ensembleSize;
    }

    public String local() {
        return this.local;
    }

    public String ensemble() {
        return this.ensemble;
    }

    public int ensembleSize() {
        return this.ensembleSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionSpec that = (ConnectionSpec)o;
        return this.ensembleSize == that.ensembleSize && this.local.equals(that.local) && this.ensemble.equals(that.ensemble);
    }

    public int hashCode() {
        return Objects.hash(this.local, this.ensemble, this.ensembleSize);
    }

    public static ConnectionSpec create(String spec) {
        return ConnectionSpec.create(spec, spec);
    }

    public static ConnectionSpec create(String localSpec, String ensembleSpec) {
        return new ConnectionSpec(localSpec, ensembleSpec, ensembleSpec.split(",").length);
    }

    public static <T> ConnectionSpec create(List<T> servers, Function<T, String> hostnameGetter, Function<T, Integer> portGetter, boolean localhostAffinity) {
        String localSpec = ConnectionSpec.createSpec(servers, hostnameGetter, portGetter, localhostAffinity);
        String ensembleSpec = localhostAffinity ? ConnectionSpec.createSpec(servers, hostnameGetter, portGetter, false) : localSpec;
        return new ConnectionSpec(localSpec, ensembleSpec, servers.size());
    }

    private static <T> String createSpec(List<T> servers, Function<T, String> hostnameGetter, Function<T, Integer> portGetter, boolean localhostAffinity) {
        String thisServer = HostName.getLocalhost();
        StringBuilder connectionSpec = new StringBuilder();
        for (T server : servers) {
            if (localhostAffinity && !thisServer.equals(hostnameGetter.apply(server))) continue;
            connectionSpec.append(hostnameGetter.apply(server));
            connectionSpec.append(':');
            connectionSpec.append(portGetter.apply(server));
            connectionSpec.append(',');
        }
        if (localhostAffinity && connectionSpec.length() == 0) {
            throw new IllegalArgumentException("Unable to create connect string to localhost: There is no localhost server specified in config");
        }
        if (connectionSpec.length() > 0) {
            connectionSpec.setLength(connectionSpec.length() - 1);
        }
        return connectionSpec.toString();
    }

    private static String requireNonEmpty(String s, String field) {
        if (Objects.requireNonNull(s).isEmpty()) {
            throw new IllegalArgumentException(field + " must be non-empty");
        }
        return s;
    }
}

