/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;

public class ZooKeeperServer
extends AbstractComponent
implements Runnable {
    private static final Logger log = Logger.getLogger(ZooKeeperServer.class.getName());
    private static final String ZOOKEEPER_JMX_LOG4J_DISABLE = "zookeeper.jmx.log4j.disable";
    static final String ZOOKEEPER_JUTE_MAX_BUFFER = "jute.maxbuffer";
    private final Thread zkServerThread;
    private final ZookeeperServerConfig zookeeperServerConfig;

    ZooKeeperServer(ZookeeperServerConfig zookeeperServerConfig, boolean startServer) {
        this.zookeeperServerConfig = zookeeperServerConfig;
        System.setProperty(ZOOKEEPER_JMX_LOG4J_DISABLE, "true");
        System.setProperty(ZOOKEEPER_JUTE_MAX_BUFFER, "" + zookeeperServerConfig.juteMaxBuffer());
        System.setProperty("zookeeper.serverCnxnFactory", "com.yahoo.vespa.zookeeper.RestrictedServerCnxnFactory");
        this.writeConfigToDisk(zookeeperServerConfig);
        this.zkServerThread = new Thread((Runnable)this, "zookeeper server");
        if (startServer) {
            this.zkServerThread.start();
        }
    }

    @Inject
    public ZooKeeperServer(ZookeeperServerConfig zookeeperServerConfig) {
        this(zookeeperServerConfig, true);
    }

    private void writeConfigToDisk(ZookeeperServerConfig config) {
        String configFilePath = Defaults.getDefaults().underVespaHome(config.zooKeeperConfigFile());
        new File(configFilePath).getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(configFilePath);){
            writer.write(this.transformConfigToString(config));
            this.writeMyIdFile(config);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing zookeeper config", e);
        }
    }

    private String transformConfigToString(ZookeeperServerConfig config) {
        StringBuilder sb = new StringBuilder();
        sb.append("tickTime=").append(config.tickTime()).append("\n");
        sb.append("initLimit=").append(config.initLimit()).append("\n");
        sb.append("syncLimit=").append(config.syncLimit()).append("\n");
        sb.append("maxClientCnxns=").append(config.maxClientConnections()).append("\n");
        sb.append("snapCount=").append(config.snapshotCount()).append("\n");
        sb.append("dataDir=").append(Defaults.getDefaults().underVespaHome(config.dataDir())).append("\n");
        sb.append("clientPort=").append(config.clientPort()).append("\n");
        sb.append("autopurge.purgeInterval=").append(config.autopurge().purgeInterval()).append("\n");
        sb.append("autopurge.snapRetainCount=").append(config.autopurge().snapRetainCount()).append("\n");
        sb.append("4lw.commands.whitelist=conf,cons,crst,dump,envi,mntr,ruok,srst,srvr,stat,wchs").append("\n");
        if (config.server().size() > 1) {
            this.ensureThisServerIsRepresented(config.myid(), config.server());
            for (ZookeeperServerConfig.Server server : config.server()) {
                this.addServerToCfg(sb, server);
            }
        }
        return sb.toString();
    }

    private void writeMyIdFile(ZookeeperServerConfig config) throws IOException {
        if (config.server().size() > 1) {
            try (FileWriter writer = new FileWriter(Defaults.getDefaults().underVespaHome(config.myidFile()));){
                writer.write(config.myid() + "\n");
            }
        }
    }

    private void ensureThisServerIsRepresented(int myid, List<ZookeeperServerConfig.Server> servers) {
        boolean found = false;
        for (ZookeeperServerConfig.Server server : servers) {
            if (myid != server.id()) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("No id in zookeeper server list that corresponds to my id(" + myid + ")");
        }
    }

    private void addServerToCfg(StringBuilder sb, ZookeeperServerConfig.Server server) {
        sb.append("server.").append(server.id()).append("=").append(server.hostname()).append(":").append(server.quorumPort()).append(":").append(server.electionPort()).append("\n");
    }

    private void shutdown() {
        this.zkServerThread.interrupt();
        try {
            this.zkServerThread.join();
        }
        catch (InterruptedException e) {
            log.log(LogLevel.WARNING, "Error joining server thread on shutdown", e);
        }
    }

    @Override
    public void run() {
        System.setProperty(ZOOKEEPER_JMX_LOG4J_DISABLE, "true");
        String[] args = new String[]{Defaults.getDefaults().underVespaHome(this.zookeeperServerConfig.zooKeeperConfigFile())};
        log.log((Level)LogLevel.DEBUG, "Starting ZooKeeper server with config: " + args[0]);
        log.log(LogLevel.INFO, "Trying to establish ZooKeeper quorum (from " + ZooKeeperServer.zookeeperServerHostnames(this.zookeeperServerConfig) + ")");
        QuorumPeerMain.main((String[])args);
    }

    public void deconstruct() {
        this.shutdown();
        super.deconstruct();
    }

    public ZookeeperServerConfig getZookeeperServerConfig() {
        return this.zookeeperServerConfig;
    }

    private static Set<String> zookeeperServerHostnames(ZookeeperServerConfig zookeeperServerConfig) {
        return zookeeperServerConfig.server().stream().map(ZookeeperServerConfig.Server::hostname).collect(Collectors.toSet());
    }
}

