/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.stats;

import com.yahoo.vespa.curator.stats.LockAttempt;
import com.yahoo.vespa.curator.stats.LockMetrics;
import com.yahoo.vespa.curator.stats.LockStats;
import com.yahoo.vespa.curator.stats.RecordedLockAttempts;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class ThreadLockStats {
    private static final Logger logger = Logger.getLogger(ThreadLockStats.class.getName());
    private final Thread thread;
    private final ConcurrentLinkedDeque<LockAttempt> lockAttemptsStack = new ConcurrentLinkedDeque();
    private volatile Optional<RecordedLockAttempts> ongoingRecording = Optional.empty();

    ThreadLockStats(Thread currentThread) {
        this.thread = currentThread;
    }

    public String getThreadName() {
        return this.thread.getName();
    }

    public String getStackTrace() {
        StringBuilder stackTrace = new StringBuilder();
        StackTraceElement[] elements = this.thread.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            stackTrace.append(element.getClassName()).append('.').append(element.getMethodName()).append('(').append(element.getFileName()).append(':').append(element.getLineNumber()).append(")\n");
        }
        return stackTrace.toString();
    }

    public List<LockAttempt> getOngoingLockAttempts() {
        return List.copyOf(this.lockAttemptsStack);
    }

    public Optional<LockAttempt> getTopMostOngoingLockAttempt() {
        return this.lockAttemptsStack.stream().findFirst();
    }

    public Optional<RecordedLockAttempts> getOngoingRecording() {
        return this.ongoingRecording;
    }

    public void invokingAcquire(String lockPath, Duration timeout) {
        LockAttempt lockAttempt = LockAttempt.invokingAcquire(this, lockPath, timeout, this.getGlobalLockMetrics(lockPath));
        LockAttempt lastLockAttempt = this.lockAttemptsStack.peekLast();
        if (lastLockAttempt == null) {
            this.ongoingRecording.ifPresent(recording -> recording.addTopLevelLockAttempt(lockAttempt));
        } else {
            lastLockAttempt.addNestedLockAttempt(lockAttempt);
        }
        this.lockAttemptsStack.addLast(lockAttempt);
    }

    public void acquireFailed() {
        this.removeLastLockAttempt(LockAttempt::acquireFailed);
    }

    public void acquireTimedOut() {
        this.removeLastLockAttempt(LockAttempt::timedOut);
    }

    public void lockAcquired() {
        LockAttempt lockAttempt = this.lockAttemptsStack.peekLast();
        if (lockAttempt == null) {
            logger.warning("Unable to get last lock attempt as the lock attempt stack is empty");
            return;
        }
        lockAttempt.lockAcquired();
    }

    public void lockReleased() {
        this.removeLastLockAttempt(LockAttempt::released);
    }

    public void lockReleaseFailed() {
        this.removeLastLockAttempt(LockAttempt::releasedWithError);
    }

    public void startRecording(String recordId) {
        this.ongoingRecording = Optional.of(RecordedLockAttempts.startRecording(recordId));
    }

    public void stopRecording() {
        if (this.ongoingRecording.isPresent()) {
            RecordedLockAttempts recording = this.ongoingRecording.get();
            this.ongoingRecording = Optional.empty();
            recording.stopRecording();
            LockStats.getGlobal().reportNewStoppedRecording(recording);
        }
    }

    private LockMetrics getGlobalLockMetrics(String lockPath) {
        return LockStats.getGlobal().getLockMetrics(lockPath);
    }

    private void removeLastLockAttempt(Consumer<LockAttempt> completeLockAttempt) {
        LockAttempt lockAttempt = this.lockAttemptsStack.pollLast();
        if (lockAttempt == null) {
            logger.warning("Unable to remove last lock attempt as the lock attempt stack is empty");
            return;
        }
        completeLockAttempt.accept(lockAttempt);
        LockStats.getGlobal().maybeSample(lockAttempt);
    }
}

