/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.stats;

import com.yahoo.vespa.curator.stats.LockAttempt;
import com.yahoo.vespa.curator.stats.LockAttemptSamples;
import com.yahoo.vespa.curator.stats.LockMetrics;
import com.yahoo.vespa.curator.stats.RecordedLockAttempts;
import com.yahoo.vespa.curator.stats.ThreadLockStats;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;

public class LockStats {
    private static LockStats stats = new LockStats();
    private final ConcurrentHashMap<Thread, ThreadLockStats> statsByThread = new ConcurrentHashMap();
    private final LockAttemptSamples completedLockAttemptSamples = new LockAttemptSamples(3);
    private static final int MAX_RECORDINGS = 3;
    private final Object interestingRecordingsMonitor = new Object();
    private final PriorityQueue<RecordedLockAttempts> interestingRecordings = new PriorityQueue<RecordedLockAttempts>(3, Comparator.comparing(RecordedLockAttempts::duration));
    private final ConcurrentHashMap<String, LockMetrics> metricsByLockPath = new ConcurrentHashMap();

    public static LockStats getGlobal() {
        return stats;
    }

    public static ThreadLockStats getForCurrentThread() {
        return LockStats.stats.statsByThread.computeIfAbsent(Thread.currentThread(), ThreadLockStats::new);
    }

    public static void clearForTesting() {
        stats = new LockStats();
    }

    private LockStats() {
    }

    public Map<String, LockMetrics> getLockMetricsByPath() {
        return Map.copyOf(this.metricsByLockPath);
    }

    public List<ThreadLockStats> getThreadLockStats() {
        return List.copyOf(this.statsByThread.values());
    }

    public List<LockAttempt> getLockAttemptSamples() {
        return this.completedLockAttemptSamples.asList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecordedLockAttempts> getHistoricRecordings() {
        Object object = this.interestingRecordingsMonitor;
        synchronized (object) {
            return List.copyOf(this.interestingRecordings);
        }
    }

    LockMetrics getLockMetrics(String lockPath) {
        return this.metricsByLockPath.computeIfAbsent(lockPath, __ -> new LockMetrics());
    }

    void maybeSample(LockAttempt lockAttempt) {
        this.completedLockAttemptSamples.maybeSample(lockAttempt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportNewStoppedRecording(RecordedLockAttempts recording) {
        PriorityQueue<RecordedLockAttempts> priorityQueue = this.interestingRecordings;
        synchronized (priorityQueue) {
            if (this.interestingRecordings.size() < 3) {
                this.interestingRecordings.add(recording);
            } else if (recording.duration().compareTo(this.interestingRecordings.peek().duration()) > 0) {
                this.interestingRecordings.poll();
                this.interestingRecordings.add(recording);
            }
        }
    }
}

