/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.stats;

import com.yahoo.vespa.curator.stats.LatencyMetrics;
import com.yahoo.vespa.curator.stats.LatencyStats;
import java.util.concurrent.atomic.AtomicInteger;

public class LockMetrics {
    private final AtomicInteger acquireCount = new AtomicInteger(0);
    private final AtomicInteger acquireFailedCount = new AtomicInteger(0);
    private final AtomicInteger acquireTimedOutCount = new AtomicInteger(0);
    private final AtomicInteger acquireSucceededCount = new AtomicInteger(0);
    private final AtomicInteger releaseCount = new AtomicInteger(0);
    private final AtomicInteger releaseFailedCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeAcquireCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeAcquireFailedCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeAcquireTimedOutCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeAcquireSucceededCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeReleaseCount = new AtomicInteger(0);
    private final AtomicInteger cumulativeReleaseFailedCount = new AtomicInteger(0);
    private final LatencyStats acquireStats = new LatencyStats();
    private final LatencyStats lockedStats = new LatencyStats();

    LatencyStats.ActiveInterval acquireInvoked() {
        this.acquireCount.incrementAndGet();
        this.cumulativeAcquireCount.incrementAndGet();
        return this.acquireStats.startNewInterval();
    }

    void acquireFailed(LatencyStats.ActiveInterval acquireInterval) {
        acquireInterval.close();
        this.acquireFailedCount.incrementAndGet();
        this.cumulativeAcquireFailedCount.incrementAndGet();
    }

    void acquireTimedOut(LatencyStats.ActiveInterval acquireInterval) {
        acquireInterval.close();
        this.acquireTimedOutCount.incrementAndGet();
        this.cumulativeAcquireTimedOutCount.incrementAndGet();
    }

    LatencyStats.ActiveInterval lockAcquired(LatencyStats.ActiveInterval acquireInterval) {
        acquireInterval.close();
        this.acquireSucceededCount.incrementAndGet();
        this.cumulativeAcquireSucceededCount.incrementAndGet();
        return this.lockedStats.startNewInterval();
    }

    void release(LatencyStats.ActiveInterval lockedInterval) {
        lockedInterval.close();
        this.releaseCount.incrementAndGet();
        this.cumulativeReleaseCount.incrementAndGet();
    }

    void releaseFailed(LatencyStats.ActiveInterval lockedInterval) {
        this.release(lockedInterval);
        this.releaseFailedCount.incrementAndGet();
        this.cumulativeReleaseFailedCount.incrementAndGet();
    }

    public int getAndResetAcquireCount() {
        return this.acquireCount.getAndSet(0);
    }

    public int getAndResetAcquireFailedCount() {
        return this.acquireFailedCount.getAndSet(0);
    }

    public int getAndResetAcquireTimedOutCount() {
        return this.acquireTimedOutCount.getAndSet(0);
    }

    public int getAndResetAcquireSucceededCount() {
        return this.acquireSucceededCount.getAndSet(0);
    }

    public int getAndResetReleaseCount() {
        return this.releaseCount.getAndSet(0);
    }

    public int getAndResetReleaseFailedCount() {
        return this.releaseFailedCount.getAndSet(0);
    }

    public int getCumulativeAcquireCount() {
        return this.cumulativeAcquireCount.get();
    }

    public int getCumulativeAcquireFailedCount() {
        return this.cumulativeAcquireFailedCount.get();
    }

    public int getCumulativeAcquireTimedOutCount() {
        return this.cumulativeAcquireTimedOutCount.get();
    }

    public int getCumulativeAcquireSucceededCount() {
        return this.cumulativeAcquireSucceededCount.get();
    }

    public int getCumulativeReleaseCount() {
        return this.cumulativeReleaseCount.get();
    }

    public int getCumulativeReleaseFailedCount() {
        return this.cumulativeReleaseFailedCount.get();
    }

    public LatencyMetrics getAcquireLatencyMetrics() {
        return this.acquireStats.getLatencyMetrics();
    }

    public LatencyMetrics getLockedLatencyMetrics() {
        return this.lockedStats.getLatencyMetrics();
    }

    public LatencyMetrics getAndResetAcquireLatencyMetrics() {
        return this.acquireStats.getLatencyMetricsAndStartNewPeriod();
    }

    public LatencyMetrics getAndResetLockedLatencyMetrics() {
        return this.lockedStats.getLatencyMetricsAndStartNewPeriod();
    }

    void setAcquireCount(int count) {
        this.acquireCount.set(count);
    }

    void setAcquireFailedCount(int count) {
        this.acquireFailedCount.set(count);
    }

    void setAcquireTimedOutCount(int count) {
        this.acquireTimedOutCount.set(count);
    }

    void setAcquireSucceededCount(int count) {
        this.acquireSucceededCount.set(count);
    }

    void setReleaseCount(int count) {
        this.releaseCount.set(count);
    }

    void setReleaseFailedCount(int count) {
        this.releaseFailedCount.set(count);
    }

    void setCumulativeAcquireCount(int count) {
        this.cumulativeAcquireCount.set(count);
    }

    void setCumulativeAcquireFailedCount(int count) {
        this.cumulativeAcquireFailedCount.set(count);
    }

    void setCumulativeAcquireTimedOutCount(int count) {
        this.cumulativeAcquireTimedOutCount.set(count);
    }

    void setCumulativeAcquireSucceededCount(int count) {
        this.cumulativeAcquireSucceededCount.set(count);
    }

    void setCumulativeReleaseCount(int count) {
        this.cumulativeReleaseCount.set(count);
    }

    void setCumulativeReleaseFailedCount(int count) {
        this.cumulativeReleaseFailedCount.set(count);
    }

    public String toString() {
        return "LockMetrics{acquireCount=" + this.acquireCount + ", acquireFailedCount=" + this.acquireFailedCount + ", acquireTimedOutCount=" + this.acquireTimedOutCount + ", acquireSucceededCount=" + this.acquireSucceededCount + ", releaseCount=" + this.releaseCount + ", releaseFailedCount=" + this.releaseFailedCount + ", cumulativeAcquireCount=" + this.cumulativeAcquireCount + ", cumulativeAcquireFailedCount=" + this.cumulativeAcquireFailedCount + ", cumulativeAcquireTimedOutCount=" + this.cumulativeAcquireTimedOutCount + ", cumulativeAcquireSucceededCount=" + this.cumulativeAcquireSucceededCount + ", cumulativeReleaseCount=" + this.cumulativeReleaseCount + ", cumulativeReleaseFailedCount=" + this.cumulativeReleaseFailedCount + ", acquireStats=" + this.acquireStats + ", lockedStats=" + this.lockedStats + "}";
    }
}

