/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.yahoo.path.Path;
import com.yahoo.vespa.curator.CompletionTimeoutException;
import com.yahoo.vespa.curator.Curator;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class CuratorCompletionWaiter
implements Curator.CompletionWaiter {
    private static final Logger log = Logger.getLogger(CuratorCompletionWaiter.class.getName());
    private final Curator curator;
    private final String barrierPath;
    private final String myId;
    private final Clock clock;

    CuratorCompletionWaiter(Curator curator, String barrierPath, String myId, Clock clock) {
        this.myId = barrierPath + "/" + myId;
        this.curator = curator;
        this.barrierPath = barrierPath;
        this.clock = clock;
    }

    @Override
    public void awaitCompletion(Duration timeout) {
        List<String> respondents;
        try {
            log.log(Level.FINE, "Synchronizing on barrier " + this.barrierPath);
            respondents = this.awaitInternal(timeout);
            log.log(Level.FINE, "Done synchronizing on barrier " + this.barrierPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (respondents.size() < this.barrierMemberCount()) {
            throw new CompletionTimeoutException("Timed out waiting for peer config servers to complete operation. Got response from " + respondents + ", but need response from at least " + this.barrierMemberCount() + " server(s). Timeout passed as argument was " + timeout.toMillis() + " ms");
        }
    }

    private List<String> awaitInternal(Duration timeout) throws Exception {
        List respondents;
        Instant startTime = this.clock.instant();
        Instant endTime = startTime.plus(timeout);
        do {
            if ((respondents = (List)this.curator.framework().getChildren().forPath(this.barrierPath)).size() == this.curator.zooKeeperEnsembleCount()) {
                log.log(Level.FINE, this.barrierCompletedMessage(respondents, startTime));
                break;
            }
            if (respondents.size() >= this.barrierMemberCount()) {
                log.log(Level.FINE, this.barrierCompletedMessage(respondents, startTime));
                break;
            }
            Thread.sleep(100L);
        } while (this.clock.instant().isBefore(endTime));
        return respondents;
    }

    private String barrierCompletedMessage(List<String> respondents, Instant startTime) {
        return this.barrierPath + " completed in " + Duration.between(startTime, Instant.now()).toString() + ", " + respondents.size() + "/" + this.curator.zooKeeperEnsembleCount() + " responded: " + respondents;
    }

    @Override
    public void notifyCompletion() {
        try {
            this.notifyInternal();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void notifyInternal() throws Exception {
        this.curator.framework().create().forPath(this.myId);
    }

    public String toString() {
        return "'" + this.barrierPath + "', " + this.barrierMemberCount() + " members";
    }

    public static Curator.CompletionWaiter create(Curator curator, Path barrierPath, String id) {
        return new CuratorCompletionWaiter(curator, barrierPath.getAbsolute(), id, Clock.systemUTC());
    }

    public static Curator.CompletionWaiter createAndInitialize(Curator curator, Path parentPath, String waiterNode, String id) {
        Path waiterPath = parentPath.append(waiterNode);
        curator.delete(waiterPath);
        curator.createAtomically(waiterPath);
        return new CuratorCompletionWaiter(curator, waiterPath.getAbsolute(), id, Clock.systemUTC());
    }

    private int barrierMemberCount() {
        return this.curator.zooKeeperEnsembleCount() / 2 + 1;
    }
}

