/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.yahoo.transaction.Mutex;
import com.yahoo.vespa.curator.Curator;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.curator.framework.recipes.locks.InterProcessLock;

public class Lock
implements Mutex {
    private final ReentrantLock lock;
    private final InterProcessLock mutex;
    private final String lockPath;

    public Lock(String lockPath, Curator curator) {
        this.lockPath = lockPath;
        this.lock = new ReentrantLock(true);
        this.mutex = curator.createMutex(lockPath);
    }

    public void acquire(Duration timeout) throws UncheckedTimeoutException {
        try {
            if (!this.mutex.acquire(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new UncheckedTimeoutException("Timed out after waiting " + timeout + " to acquire lock '" + this.lockPath + "'");
            }
            if (!this.lock.tryLock()) {
                this.release();
                throw new IllegalStateException("InterProcessMutex acquired, but guarded lock held by someone else, for lock '" + this.lockPath + "'");
            }
        }
        catch (UncheckedTimeoutException | IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception acquiring lock '" + this.lockPath + "'", e);
        }
    }

    public void close() {
        try {
            this.lock.unlock();
        }
        finally {
            this.release();
        }
    }

    private void release() {
        try {
            this.mutex.release();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception releasing lock '" + this.lockPath + "'");
        }
    }
}

